/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.apache.geode.DataSerializer;
import org.apache.geode.Delta;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.gemfire.GemfireAccessor;
import org.springframework.data.gemfire.GemfireOperations;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.data.gemfire.config.annotation.web.http.GemFireHttpSessionConfiguration;
import org.springframework.session.data.gemfire.events.SessionChangedEvent;
import org.springframework.session.data.gemfire.support.GemFireUtils;
import org.springframework.session.data.gemfire.support.IsDirtyPredicate;
import org.springframework.session.data.gemfire.support.SessionIdHolder;
import org.springframework.session.data.gemfire.support.SessionUtils;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionDestroyedEvent;
import org.springframework.session.events.SessionExpiredEvent;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractGemFireOperationsSessionRepository
implements ApplicationEventPublisherAware,
FindByIndexNameSessionRepository<Session> {
    private static final boolean DEFAULT_CLIENT_SUBSCRIPTIONS_ENABLED = false;
    private static final boolean DEFAULT_REGISTER_INTEREST_DURABILITY = false;
    private static final boolean DEFAULT_REGISTER_INTEREST_ENABLED = false;
    private static final boolean DEFAULT_REGISTER_INTEREST_RECEIVE_VALUES = true;
    private static final AtomicBoolean usingDataSerialization = new AtomicBoolean(false);
    private static final Duration DEFAULT_MAX_INACTIVE_INTERVAL = Duration.ofSeconds(GemFireHttpSessionConfiguration.DEFAULT_MAX_INACTIVE_INTERVAL_IN_SECONDS);
    private static final InterestResultPolicy DEFAULT_REGISTER_INTEREST_RESULT_POLICY = InterestResultPolicy.NONE;
    private static final IsDirtyPredicate DEFAULT_IS_DIRTY_PREDICATE = GemFireHttpSessionConfiguration.DEFAULT_IS_DIRTY_PREDICATE;
    private boolean registerInterestEnabled = false;
    private ApplicationEventPublisher applicationEventPublisher;
    private Duration maxInactiveInterval;
    private final GemfireOperations template;
    private IsDirtyPredicate dirtyPredicate;
    private final Logger logger;
    private final Region<Object, Session> sessions;
    private SessionEventHandlerCacheListenerAdapter sessionEventHandler;
    private final Set<Integer> interestingSessionIds;

    protected AbstractGemFireOperationsSessionRepository() {
        this.applicationEventPublisher = event -> {};
        this.maxInactiveInterval = DEFAULT_MAX_INACTIVE_INTERVAL;
        this.dirtyPredicate = DEFAULT_IS_DIRTY_PREDICATE;
        this.logger = this.newLogger();
        this.interestingSessionIds = new ConcurrentSkipListSet<Integer>();
        this.sessions = null;
        this.template = null;
    }

    public AbstractGemFireOperationsSessionRepository(GemfireOperations template) {
        this.applicationEventPublisher = event -> {};
        this.maxInactiveInterval = DEFAULT_MAX_INACTIVE_INTERVAL;
        this.dirtyPredicate = DEFAULT_IS_DIRTY_PREDICATE;
        this.logger = this.newLogger();
        this.interestingSessionIds = new ConcurrentSkipListSet<Integer>();
        Assert.notNull((Object)template, (String)"GemfireOperations is required");
        this.template = template;
        this.sessions = this.initializeSessionsRegion(this.resolveSessionsRegion(template));
    }

    private Region<Object, Session> resolveSessionsRegion(@Nullable GemfireOperations gemfireOperations) {
        return Optional.ofNullable(gemfireOperations).filter(GemfireAccessor.class::isInstance).map(GemfireAccessor.class::cast).map(GemfireAccessor::getRegion).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"The ClusteredSpringSessions Region could not be resolved", (Object[])new Object[0]));
    }

    @Nullable
    private Region<Object, Session> initializeSessionsRegion(@Nullable Region<Object, Session> sessionsRegion) {
        Optional.ofNullable(sessionsRegion).map(Region::getAttributesMutator).ifPresent(sessionsRegionAttributesMutator -> {
            this.sessionEventHandler = this.newSessionEventHandler();
            sessionsRegionAttributesMutator.addCacheListener((CacheListener)this.sessionEventHandler);
            if (this.isRegionRegisterInterestAllowed(sessionsRegion)) {
                this.registerInterestEnabled = true;
                sessionsRegionAttributesMutator.addCacheListener((CacheListener)this.newSessionIdInterestRegistrar());
            }
        });
        return sessionsRegion;
    }

    boolean isNonLocalClientRegion(@Nullable Region<?, ?> region) {
        return GemFireUtils.isNonLocalClientRegion(region);
    }

    boolean isRegionPoolSubscriptionEnabled(@Nullable Region<?, ?> region) {
        return Boolean.TRUE.equals(Optional.ofNullable(region).map(Region::getAttributes).map(RegionAttributes::getPoolName).map(this::resolvePool).map(Pool::getSubscriptionEnabled).orElse(false));
    }

    boolean isRegionRegisterInterestAllowed(@Nullable Region<?, ?> region) {
        return this.isNonLocalClientRegion(region) && this.isRegionPoolSubscriptionEnabled(region);
    }

    @Nullable
    protected Pool resolvePool(String name) {
        return PoolManager.find((String)name);
    }

    private Logger newLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    protected SessionEventHandlerCacheListenerAdapter newSessionEventHandler() {
        return new SessionEventHandlerCacheListenerAdapter(this);
    }

    protected SessionIdInterestRegisteringCacheListener newSessionIdInterestRegistrar() {
        return new SessionIdInterestRegisteringCacheListener(this);
    }

    public void setApplicationEventPublisher(@NonNull ApplicationEventPublisher applicationEventPublisher) {
        Assert.notNull((Object)applicationEventPublisher, (String)"ApplicationEventPublisher is required");
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @NonNull
    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public void setIsDirtyPredicate(IsDirtyPredicate dirtyPredicate) {
        this.dirtyPredicate = dirtyPredicate;
    }

    public IsDirtyPredicate getIsDirtyPredicate() {
        return this.dirtyPredicate != null ? this.dirtyPredicate : DEFAULT_IS_DIRTY_PREDICATE;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void setMaxInactiveInterval(Duration maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public Duration getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.setMaxInactiveInterval(Duration.ofSeconds(maxInactiveIntervalInSeconds));
    }

    public int getMaxInactiveIntervalInSeconds() {
        return Optional.ofNullable(this.getMaxInactiveInterval()).map(Duration::getSeconds).map(Long::intValue).orElse(0);
    }

    protected boolean isRegisterInterestEnabled() {
        return this.registerInterestEnabled;
    }

    protected Optional<SessionEventHandlerCacheListenerAdapter> getSessionEventHandler() {
        return Optional.ofNullable(this.sessionEventHandler);
    }

    @NonNull
    protected Region<Object, Session> getSessionsRegion() {
        return this.sessions;
    }

    protected String getSessionsRegionName() {
        return this.getSessionsRegion().getFullPath();
    }

    @NonNull
    public GemfireOperations getSessionsTemplate() {
        return this.template;
    }

    @Deprecated
    @NonNull
    public GemfireOperations getTemplate() {
        return this.getSessionsTemplate();
    }

    public void setUseDataSerialization(boolean useDataSerialization) {
        usingDataSerialization.set(useDataSerialization);
    }

    protected static boolean isUsingDataSerialization() {
        return usingDataSerialization.get() || AbstractGemFireOperationsSessionRepository.resolveSystemUsingDataSerialization();
    }

    private static boolean resolveSystemUsingDataSerialization() {
        String configuredSessionSerializerBeanName = System.getProperty("spring.session.data.gemfire.session.serializer.bean-name", "SessionPdxSerializer");
        boolean systemUsingDataSerialization = "SessionDataSerializer".equals(configuredSessionSerializerBeanName);
        usingDataSerialization.set(systemUsingDataSerialization);
        return systemUsingDataSerialization;
    }

    @Nullable
    protected Session commit(@Nullable Session session) {
        return Optional.ofNullable(session).filter(GemFireSession.class::isInstance).map(GemFireSession.class::cast).map(gemfireSession -> {
            gemfireSession.commit();
            return gemfireSession;
        }).orElse(session);
    }

    @Nullable
    protected Session configure(@Nullable Session session) {
        return Optional.ofNullable(session).filter(GemFireSession.class::isInstance).map(GemFireSession.class::cast).map(it -> it.configureWith(this.getMaxInactiveInterval())).map(it -> it.configureWith(this.getIsDirtyPredicate())).orElse(session);
    }

    @Nullable
    protected Session delete(@NonNull Session session) {
        this.deleteById(session.getId());
        return null;
    }

    protected void handleDeleted(String sessionId, Session session) {
        this.getSessionEventHandler().ifPresent(it -> it.afterDelete(sessionId, session));
        this.unregisterInterest(sessionId);
    }

    protected void publishEvent(ApplicationEvent event) {
        try {
            this.getApplicationEventPublisher().publishEvent(event);
        }
        catch (Throwable cause) {
            this.getLogger().error(String.format("Error occurred while publishing event [%s]", event), cause);
        }
    }

    protected Session registerInterest(@Nullable Session session) {
        Optional.ofNullable(session).map(Session::getId).ifPresent(this::registerInterest);
        return session;
    }

    protected void registerInterest(@Nullable Object sessionId) {
        Optional.ofNullable(sessionId).filter(it -> this.isRegisterInterestEnabled()).filter(SessionUtils::isValidSessionId).map(ObjectUtils::nullSafeHashCode).filter(this.interestingSessionIds::add).ifPresent(it -> this.getSessionsRegion().registerInterest(sessionId, DEFAULT_REGISTER_INTEREST_RESULT_POLICY, false, true));
    }

    @NonNull
    protected Session touch(@NonNull Session session) {
        session.setLastAccessedTime(Instant.now());
        return session;
    }

    protected Session unregisterInterest(@Nullable Session session) {
        Optional.ofNullable(session).map(Session::getId).ifPresent(this::unregisterInterest);
        return session;
    }

    protected void unregisterInterest(@Nullable Object sessionId) {
        Optional.ofNullable(sessionId).filter(it -> this.isRegisterInterestEnabled()).map(ObjectUtils::nullSafeHashCode).filter(this.interestingSessionIds::remove).ifPresent(it -> this.getSessionsRegion().unregisterInterest(sessionId));
    }

    protected static class SessionIdInterestRegisteringCacheListener
    extends CacheListenerAdapter<Object, Session> {
        private final AbstractGemFireOperationsSessionRepository sessionRepository;

        public SessionIdInterestRegisteringCacheListener(AbstractGemFireOperationsSessionRepository sessionRepository) {
            Assert.notNull((Object)sessionRepository, (String)"SessionRepository is required");
            this.sessionRepository = sessionRepository;
        }

        protected AbstractGemFireOperationsSessionRepository getSessionRepository() {
            return this.sessionRepository;
        }

        public void afterCreate(EntryEvent<Object, Session> event) {
            this.getSessionRepository().registerInterest(event.getKey());
        }

        public void afterDestroy(EntryEvent<Object, Session> event) {
            this.getSessionRepository().unregisterInterest(event.getKey());
        }

        public void afterInvalidate(EntryEvent<Object, Session> event) {
            this.getSessionRepository().unregisterInterest(event.getKey());
        }
    }

    protected static class SessionEventHandlerCacheListenerAdapter
    extends CacheListenerAdapter<Object, Session> {
        private final AbstractGemFireOperationsSessionRepository sessionRepository;
        private final Set<Integer> cachedSessionIds = new ConcurrentSkipListSet<Integer>();

        protected SessionEventHandlerCacheListenerAdapter(AbstractGemFireOperationsSessionRepository sessionRepository) {
            Assert.notNull((Object)sessionRepository, (String)"SessionRepository is required");
            this.sessionRepository = sessionRepository;
        }

        @NonNull
        protected AbstractGemFireOperationsSessionRepository getSessionRepository() {
            return this.sessionRepository;
        }

        public void afterCreate(EntryEvent<Object, Session> event) {
            Optional.ofNullable(event).filter(this::isNotLocalLoadEvent).filter(this::remember).ifPresent(it -> this.getSessionRepository().publishEvent((ApplicationEvent)this.newSessionCreatedEvent(this.toSession(it.getNewValue(), it.getKey()))));
        }

        protected void afterDelete(String sessionId, Session session) {
            this.forget(sessionId);
            this.getSessionRepository().publishEvent((ApplicationEvent)this.newSessionDeletedEvent(this.toSession(session, sessionId)));
        }

        public void afterDestroy(EntryEvent<Object, Session> event) {
            Optional.ofNullable(event).filter(this::forget).ifPresent(it -> this.getSessionRepository().publishEvent((ApplicationEvent)this.newSessionDestroyedEvent(this.toSession(event.getOldValue(), it.getKey()))));
        }

        public void afterInvalidate(EntryEvent<Object, Session> event) {
            Optional.ofNullable(event).filter(this::forget).ifPresent(it -> this.getSessionRepository().publishEvent((ApplicationEvent)this.newSessionExpiredEvent(this.toSession(event.getOldValue(), it.getKey()))));
        }

        public void afterUpdate(EntryEvent<Object, Session> event) {
            Optional.ofNullable(event).ifPresent(it -> this.getSessionRepository().publishEvent(this.newSessionChangedEvent(this.toSession(event.getNewValue(), it.getKey()))));
        }

        protected SessionCreatedEvent newSessionCreatedEvent(Session session) {
            return new SessionCreatedEvent((Object)this.getSessionRepository(), session);
        }

        protected SessionChangedEvent newSessionChangedEvent(Session session) {
            return new SessionChangedEvent(this.getSessionRepository(), session);
        }

        protected SessionDeletedEvent newSessionDeletedEvent(Session session) {
            return new SessionDeletedEvent((Object)this.getSessionRepository(), session);
        }

        protected SessionDestroyedEvent newSessionDestroyedEvent(Session session) {
            return new SessionDestroyedEvent((Object)this.getSessionRepository(), session);
        }

        protected SessionExpiredEvent newSessionExpiredEvent(Session session) {
            return new SessionExpiredEvent((Object)this.getSessionRepository(), session);
        }

        Set<Integer> getCachedSessionIds() {
            return this.cachedSessionIds;
        }

        protected boolean isLocalLoadEvent(@Nullable EntryEvent<?, ?> event) {
            return event != null && event.getOperation() != null && event.getOperation().isLocalLoad();
        }

        protected boolean isNotLocalLoadEvent(@Nullable EntryEvent<?, ?> event) {
            return !this.isLocalLoadEvent(event);
        }

        protected boolean isRemembered(Object sessionId) {
            return this.getCachedSessionIds().contains(ObjectUtils.nullSafeHashCode((Object)sessionId));
        }

        protected boolean forget(EntryEvent<Object, Session> entryEvent) {
            return Optional.ofNullable(entryEvent).map(EntryEvent::getKey).map(this::forget).orElse(false);
        }

        protected boolean forget(Object sessionId) {
            return this.getCachedSessionIds().remove(ObjectUtils.nullSafeHashCode((Object)sessionId));
        }

        protected boolean remember(EntryEvent<Object, Session> entryEvent) {
            return Optional.ofNullable(entryEvent).filter(this::isSession).map(EntryEvent::getKey).filter(SessionUtils::isValidSessionId).map(this::remember).orElse(false);
        }

        protected boolean remember(Object sessionId) {
            return this.getCachedSessionIds().add(ObjectUtils.nullSafeHashCode((Object)sessionId));
        }

        protected boolean isSession(EntryEvent<?, ?> entryEvent) {
            return Optional.ofNullable(entryEvent).map(EntryEvent::getNewValue).filter(Session.class::isInstance).isPresent();
        }

        protected boolean isSession(Object target) {
            return target instanceof Session;
        }

        protected Session toSession(@Nullable Object target, Object sessionId) {
            return this.isSession(target) ? (Session)target : (Session)Optional.ofNullable(sessionId).filter(SessionUtils::isValidSessionId).map(Object::toString).map(SessionIdHolder::create).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"The Session or the Session ID [%s] must be known to trigger a Session event", (Object[])new Object[]{sessionId}));
        }
    }

    public static class GemFireSessionAttributes
    extends AbstractMap<String, Object> {
        private transient boolean delta = false;
        private transient IsDirtyPredicate dirtyPredicate = AbstractGemFireOperationsSessionRepository.access$000();
        private final transient Map<String, Object> sessionAttributes = new HashMap<String, Object>();
        private final transient Object lock;

        public static GemFireSessionAttributes create() {
            return new GemFireSessionAttributes();
        }

        public static GemFireSessionAttributes create(Object lock) {
            return new GemFireSessionAttributes(lock);
        }

        protected GemFireSessionAttributes() {
            this.lock = this;
        }

        protected GemFireSessionAttributes(@Nullable Object lock) {
            this.lock = lock != null ? lock : this;
        }

        Map<String, Object> getMap() {
            return this.sessionAttributes;
        }

        public Object getLock() {
            return this.lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setIsDirtyPredicate(IsDirtyPredicate dirtyPredicate) {
            Object object = this.getLock();
            synchronized (object) {
                this.dirtyPredicate = dirtyPredicate;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IsDirtyPredicate getIsDirtyPredicate() {
            Object object = this.getLock();
            synchronized (object) {
                return this.dirtyPredicate != null ? this.dirtyPredicate : DEFAULT_IS_DIRTY_PREDICATE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object setAttribute(String attributeName, Object attributeValue) {
            Object object = this.getLock();
            synchronized (object) {
                return attributeValue != null ? this.doSetAttribute(attributeName, attributeValue) : this.removeAttribute(attributeName);
            }
        }

        private Object doSetAttribute(String attributeName, Object attributeValue) {
            Map<String, Object> sessionAttributes = this.getMap();
            Object previousAttributeValue = sessionAttributes.put(attributeName, attributeValue);
            this.delta |= this.getIsDirtyPredicate().isDirty(previousAttributeValue, attributeValue) && this.sessionAttributesChangeInterceptor().apply(attributeName, attributeValue) != false;
            return previousAttributeValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object removeAttribute(String attributeName) {
            Object object = this.getLock();
            synchronized (object) {
                Map<String, Object> sessionAttributes = this.getMap();
                this.delta |= sessionAttributes.containsKey(attributeName) && this.sessionAttributesChangeInterceptor().apply(attributeName, null) != false;
                return sessionAttributes.remove(attributeName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T getAttribute(String attributeName) {
            Object object = this.getLock();
            synchronized (object) {
                return (T)this.getMap().get(attributeName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> getAttributeNames() {
            Object object = this.getLock();
            synchronized (object) {
                return Collections.unmodifiableSet(this.getMap().keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            Object object = this.getLock();
            synchronized (object) {
                return new AbstractSet<Map.Entry<String, Object>>(){

                    @Override
                    public Iterator<Map.Entry<String, Object>> iterator() {
                        return Collections.unmodifiableMap(this.getMap()).entrySet().iterator();
                    }

                    @Override
                    public int size() {
                        return this.getMap().size();
                    }
                };
            }
        }

        protected BiFunction<String, Object, Boolean> sessionAttributesChangeInterceptor() {
            return (attributeName, attributeValue) -> true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void commit() {
            Object object = this.getLock();
            synchronized (object) {
                this.delta = false;
            }
        }

        public <T extends GemFireSessionAttributes> T configureWith(IsDirtyPredicate dirtyPredicate) {
            this.setIsDirtyPredicate(dirtyPredicate);
            return (T)this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void from(Session session) {
            Object object = this.getLock();
            synchronized (object) {
                session.getAttributeNames().forEach((? super T attributeName) -> this.setAttribute((String)attributeName, session.getAttribute(attributeName)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void from(Map<String, Object> map) {
            Object object = this.getLock();
            synchronized (object) {
                map.forEach(this::setAttribute);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void from(GemFireSessionAttributes sessionAttributes) {
            Object object = this.getLock();
            synchronized (object) {
                sessionAttributes.getAttributeNames().forEach((? super T attributeName) -> this.setAttribute((String)attributeName, sessionAttributes.getAttribute((String)attributeName)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasDelta() {
            Object object = this.getLock();
            synchronized (object) {
                return this.delta;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            Object object = this.getLock();
            synchronized (object) {
                return this.getMap().toString();
            }
        }
    }

    public static class DeltaCapableGemFireSessionAttributes
    extends GemFireSessionAttributes
    implements Delta {
        private final transient Set<String> sessionAttributeDeltas = new HashSet<String>();

        public DeltaCapableGemFireSessionAttributes() {
        }

        public DeltaCapableGemFireSessionAttributes(Object lock) {
            super(lock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<String> getSessionAttributeDeltas() {
            Object object = this.getLock();
            synchronized (object) {
                return this.sessionAttributeDeltas;
            }
        }

        @Override
        protected BiFunction<String, Object, Boolean> sessionAttributesChangeInterceptor() {
            return (attributeName, attributeValue) -> {
                this.getSessionAttributeDeltas().add((String)attributeName);
                return true;
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void toDelta(DataOutput out) throws IOException {
            Object object = this.getLock();
            synchronized (object) {
                Set<String> sessionAttributeDeltas = this.getSessionAttributeDeltas();
                out.writeInt(sessionAttributeDeltas.size());
                for (String attributeName : sessionAttributeDeltas) {
                    out.writeUTF(attributeName);
                    this.writeObject(this.getAttribute(attributeName), out);
                }
            }
        }

        protected void writeObject(Object value, DataOutput out) throws IOException {
            DataSerializer.writeObject((Object)value, (DataOutput)out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasDelta() {
            Object object = this.getLock();
            synchronized (object) {
                return !this.getSessionAttributeDeltas().isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fromDelta(DataInput in) throws InvalidDeltaException, IOException {
            Object object = this.getLock();
            synchronized (object) {
                try {
                    int count = in.readInt();
                    HashMap<String, Object> deltas = new HashMap<String, Object>(count);
                    while (count-- > 0) {
                        deltas.put(in.readUTF(), this.readObject(in));
                    }
                    Set<String> sessionAttributeDeltas = this.getSessionAttributeDeltas();
                    deltas.forEach((key, value) -> {
                        this.setAttribute((String)key, value);
                        sessionAttributeDeltas.remove(key);
                    });
                }
                catch (ClassNotFoundException cause) {
                    throw new InvalidDeltaException("Class type in data not found", (Throwable)cause);
                }
            }
        }

        protected <T> T readObject(DataInput in) throws ClassNotFoundException, IOException {
            return (T)DataSerializer.readObject((DataInput)in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void commit() {
            Object object = this.getLock();
            synchronized (object) {
                this.getSessionAttributeDeltas().clear();
                super.commit();
            }
        }
    }

    public static class GemFireSession<T extends GemFireSessionAttributes>
    implements Comparable<Session>,
    Session {
        protected static final String GEMFIRE_SESSION_TO_STRING = "{ @type = %1$s, id = %2$s, creationTime = %3$s, lastAccessedTime = %4$s, maxInactiveInterval = %5$s, principalName = %6$s }";
        protected static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
        private transient boolean delta = true;
        private Duration maxInactiveInterval;
        private final Instant creationTime;
        private Instant lastAccessedTime;
        private transient IsDirtyPredicate dirtyPredicate = AbstractGemFireOperationsSessionRepository.access$000();
        private final transient SpelExpressionParser parser = new SpelExpressionParser();
        private String id;
        private final transient T sessionAttributes = this.newSessionAttributes(this);

        public static <T extends GemFireSessionAttributes> GemFireSession<T> create() {
            return AbstractGemFireOperationsSessionRepository.isUsingDataSerialization() ? new DeltaCapableGemFireSession() : new GemFireSession<T>();
        }

        public static GemFireSession copy(@NonNull Session session) {
            return AbstractGemFireOperationsSessionRepository.isUsingDataSerialization() ? new DeltaCapableGemFireSession(session) : new GemFireSession(session);
        }

        public static GemFireSession from(@NonNull Session session) {
            return session instanceof GemFireSession ? (GemFireSession)session : GemFireSession.copy(session);
        }

        protected GemFireSession() {
            this(GemFireSession.generateSessionId());
        }

        protected GemFireSession(String id) {
            this.id = GemFireSession.validateSessionId(id);
            this.lastAccessedTime = this.creationTime = Instant.now();
            this.maxInactiveInterval = Duration.ZERO;
        }

        protected GemFireSession(Session session) {
            Assert.notNull((Object)session, (String)"Session is required");
            this.id = session.getId();
            this.creationTime = session.getCreationTime();
            this.lastAccessedTime = session.getLastAccessedTime();
            this.maxInactiveInterval = session.getMaxInactiveInterval();
            ((GemFireSessionAttributes)this.sessionAttributes).from(session);
        }

        protected T newSessionAttributes(Object lock) {
            return new GemFireSessionAttributes(lock).configureWith(this.getIsDirtyPredicate());
        }

        public synchronized String changeSessionId() {
            this.id = GemFireSession.generateSessionId();
            this.triggerDelta();
            return this.getId();
        }

        private static String generateSessionId() {
            return UUID.randomUUID().toString();
        }

        private static String validateSessionId(String id) {
            Assert.hasText((String)id, (String)"ID is required");
            return id;
        }

        protected synchronized void commit() {
            this.delta = false;
            ((GemFireSessionAttributes)this.getAttributes()).commit();
        }

        public synchronized boolean hasDelta() {
            return this.delta || ((GemFireSessionAttributes)this.getAttributes()).hasDelta();
        }

        protected synchronized void triggerDelta() {
            this.triggerDelta(true);
        }

        protected synchronized void triggerDelta(boolean delta) {
            this.delta |= delta;
        }

        synchronized void setId(String id) {
            this.id = GemFireSession.validateSessionId(id);
        }

        public synchronized String getId() {
            return this.id;
        }

        public void setAttribute(String attributeName, Object attributeValue) {
            ((GemFireSessionAttributes)this.getAttributes()).setAttribute(attributeName, attributeValue);
        }

        public void removeAttribute(String attributeName) {
            ((GemFireSessionAttributes)this.getAttributes()).removeAttribute(attributeName);
        }

        public <T> T getAttribute(String attributeName) {
            return ((GemFireSessionAttributes)this.getAttributes()).getAttribute(attributeName);
        }

        public Set<String> getAttributeNames() {
            return ((GemFireSessionAttributes)this.getAttributes()).getAttributeNames();
        }

        public T getAttributes() {
            return this.sessionAttributes;
        }

        public synchronized Instant getCreationTime() {
            return this.creationTime;
        }

        public synchronized boolean isExpired() {
            Instant lastAccessedTime = this.getLastAccessedTime();
            Duration maxInactiveInterval = this.getMaxInactiveInterval();
            return this.isExpirationEnabled(maxInactiveInterval) && Instant.now().minus(maxInactiveInterval).isAfter(lastAccessedTime);
        }

        private boolean isExpirationDisabled(Duration duration) {
            return duration == null || duration.isNegative() || duration.isZero();
        }

        private boolean isExpirationEnabled(Duration duration) {
            return !this.isExpirationDisabled(duration);
        }

        protected synchronized void setIsDirtyPredicate(IsDirtyPredicate dirtyPredicate) {
            this.dirtyPredicate = dirtyPredicate;
            ((GemFireSessionAttributes)this.getAttributes()).configureWith(dirtyPredicate);
        }

        protected synchronized IsDirtyPredicate getIsDirtyPredicate() {
            return this.dirtyPredicate != null ? this.dirtyPredicate : DEFAULT_IS_DIRTY_PREDICATE;
        }

        private boolean isLastAccessedTimeValid(Instant lastAccessedTime) {
            return lastAccessedTime != null;
        }

        public synchronized void setLastAccessedTime(Instant lastAccessedTime) {
            if (this.isLastAccessedTimeValid(lastAccessedTime)) {
                this.triggerDelta(!ObjectUtils.nullSafeEquals((Object)this.lastAccessedTime, (Object)lastAccessedTime));
                this.lastAccessedTime = lastAccessedTime;
            }
        }

        public synchronized Instant getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public synchronized void setMaxInactiveInterval(Duration maxInactiveInterval) {
            this.triggerDelta(!ObjectUtils.nullSafeEquals((Object)this.maxInactiveInterval, (Object)maxInactiveInterval));
            this.maxInactiveInterval = maxInactiveInterval;
        }

        public synchronized Duration getMaxInactiveInterval() {
            return this.maxInactiveInterval != null ? this.maxInactiveInterval : Duration.ZERO;
        }

        public synchronized void setPrincipalName(String principalName) {
            this.setAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, principalName);
        }

        public synchronized String getPrincipalName() {
            T authentication;
            String principalName = (String)this.getAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME);
            if (principalName == null && (authentication = this.getAttribute(SPRING_SECURITY_CONTEXT)) != null) {
                Expression expression = this.parser.parseExpression("authentication?.name");
                principalName = (String)expression.getValue(authentication, String.class);
            }
            return principalName;
        }

        public GemFireSession<T> configureWith(Duration maxInactiveInterval) {
            this.setMaxInactiveInterval(maxInactiveInterval);
            return this;
        }

        public GemFireSession<T> configureWith(IsDirtyPredicate dirtyPredicate) {
            this.setIsDirtyPredicate(dirtyPredicate);
            return this;
        }

        @Override
        public int compareTo(Session session) {
            return this.getCreationTime().compareTo(session.getCreationTime());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Session)) {
                return false;
            }
            Session that = (Session)obj;
            return this.getId().equals(that.getId());
        }

        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + this.getId().hashCode();
            return hashValue;
        }

        public synchronized String toString() {
            return String.format(GEMFIRE_SESSION_TO_STRING, this.getClass().getName(), this.getId(), this.getCreationTime(), this.getLastAccessedTime(), this.getMaxInactiveInterval(), this.getPrincipalName());
        }
    }

    public static class DeltaCapableGemFireSession
    extends GemFireSession<DeltaCapableGemFireSessionAttributes>
    implements Delta {
        public DeltaCapableGemFireSession() {
        }

        public DeltaCapableGemFireSession(String id) {
            super(id);
        }

        public DeltaCapableGemFireSession(Session session) {
            super(session);
        }

        @Override
        protected DeltaCapableGemFireSessionAttributes newSessionAttributes(Object lock) {
            return (DeltaCapableGemFireSessionAttributes)new DeltaCapableGemFireSessionAttributes(lock).configureWith(this.getIsDirtyPredicate());
        }

        public synchronized void toDelta(DataOutput out) throws IOException {
            out.writeUTF(this.getId());
            out.writeLong(this.getLastAccessedTime().toEpochMilli());
            out.writeLong(this.getMaxInactiveInterval().getSeconds());
            ((DeltaCapableGemFireSessionAttributes)this.getAttributes()).toDelta(out);
        }

        public synchronized void fromDelta(DataInput in) throws IOException {
            this.setId(in.readUTF());
            this.setLastAccessedTime(Instant.ofEpochMilli(in.readLong()));
            this.setMaxInactiveInterval(Duration.ofSeconds(in.readLong()));
            ((DeltaCapableGemFireSessionAttributes)this.getAttributes()).fromDelta(in);
        }
    }
}

