/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.expiration.config;

import java.time.Duration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.lang.Nullable;
import org.springframework.session.data.gemfire.expiration.config.SessionExpirationTimeoutAware;
import org.springframework.util.Assert;

public class SessionExpirationTimeoutAwareBeanPostProcessor
implements BeanPostProcessor {
    private final Duration expirationTimeout;

    public SessionExpirationTimeoutAwareBeanPostProcessor(Duration expirationTimeout) {
        Assert.notNull((Object)expirationTimeout, (String)"Expiration timeout is required");
        this.expirationTimeout = expirationTimeout;
    }

    protected Duration getExpirationTimeout() {
        return this.expirationTimeout;
    }

    @Nullable
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof SessionExpirationTimeoutAware) {
            ((SessionExpirationTimeoutAware)bean).setExpirationTimeout(this.getExpirationTimeout());
        }
        return bean;
    }
}

