/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis.config.annotation.web.server;

import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.session.config.annotation.web.server.SpringWebSessionConfiguration;
import org.springframework.session.data.redis.ReactiveRedisOperationsSessionRepository;
import org.springframework.session.data.redis.RedisFlushMode;
import org.springframework.session.data.redis.config.annotation.SpringSessionRedisConnectionFactory;
import org.springframework.session.data.redis.config.annotation.web.server.EnableRedisWebSession;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Configuration
public class RedisWebSessionConfiguration
extends SpringWebSessionConfiguration
implements EmbeddedValueResolverAware,
ImportAware {
    private static final RedisSerializer<String> keySerializer = new StringRedisSerializer();
    private static final RedisSerializer<Object> valueSerializer = new JdkSerializationRedisSerializer();
    private Integer maxInactiveIntervalInSeconds = 1800;
    private String redisNamespace = "";
    private RedisFlushMode redisFlushMode = RedisFlushMode.ON_SAVE;
    private ReactiveRedisConnectionFactory redisConnectionFactory;
    private StringValueResolver embeddedValueResolver;

    @Bean
    public ReactiveRedisOperationsSessionRepository sessionRepository() {
        ReactiveRedisOperationsSessionRepository sessionRepository = new ReactiveRedisOperationsSessionRepository((ReactiveRedisOperations<String, Object>)RedisWebSessionConfiguration.createDefaultTemplate(this.redisConnectionFactory));
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveIntervalInSeconds);
        if (StringUtils.hasText((String)this.redisNamespace)) {
            sessionRepository.setRedisKeyNamespace(this.redisNamespace);
        }
        sessionRepository.setRedisFlushMode(this.redisFlushMode);
        return sessionRepository;
    }

    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public void setRedisNamespace(String namespace) {
        this.redisNamespace = namespace;
    }

    public void setRedisFlushMode(RedisFlushMode redisFlushMode) {
        Assert.notNull((Object)((Object)redisFlushMode), (String)"redisFlushMode cannot be null");
        this.redisFlushMode = redisFlushMode;
    }

    @Autowired
    public void setRedisConnectionFactory(@SpringSessionRedisConnectionFactory ObjectProvider<ReactiveRedisConnectionFactory> springSessionRedisConnectionFactory, ObjectProvider<ReactiveRedisConnectionFactory> redisConnectionFactory) {
        ReactiveRedisConnectionFactory redisConnectionFactoryToUse = (ReactiveRedisConnectionFactory)springSessionRedisConnectionFactory.getIfAvailable();
        if (redisConnectionFactoryToUse == null) {
            redisConnectionFactoryToUse = (ReactiveRedisConnectionFactory)redisConnectionFactory.getObject();
        }
        this.redisConnectionFactory = redisConnectionFactoryToUse;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map enableAttrMap = importMetadata.getAnnotationAttributes(EnableRedisWebSession.class.getName());
        AnnotationAttributes enableAttrs = AnnotationAttributes.fromMap((Map)enableAttrMap);
        if (enableAttrs != null) {
            this.maxInactiveIntervalInSeconds = (Integer)enableAttrs.getNumber("maxInactiveIntervalInSeconds");
            String redisNamespaceValue = enableAttrs.getString("redisNamespace");
            if (StringUtils.hasText((String)redisNamespaceValue)) {
                this.redisNamespace = this.embeddedValueResolver.resolveStringValue(redisNamespaceValue);
            }
            this.redisFlushMode = (RedisFlushMode)enableAttrs.getEnum("redisFlushMode");
        }
    }

    private static ReactiveRedisTemplate<String, Object> createDefaultTemplate(ReactiveRedisConnectionFactory connectionFactory) {
        RedisSerializationContext serializationContext = RedisSerializationContext.newSerializationContext(valueSerializer).key(keySerializer).hashKey(keySerializer).build();
        return new ReactiveRedisTemplate(connectionFactory, serializationContext);
    }
}

