/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.util.Assert;

public class MapSessionRepository
implements SessionRepository<Session> {
    private final Map<String, Session> sessions;

    public MapSessionRepository() {
        this(new ConcurrentHashMap<String, Session>());
    }

    public MapSessionRepository(Map<String, Session> sessions) {
        Assert.notNull(sessions, (String)"sessions cannot be null");
        this.sessions = sessions;
    }

    @Override
    public void save(Session session) {
        this.sessions.put(session.getId(), new MapSession(session));
    }

    @Override
    public Session getSession(String id) {
        Session result = this.sessions.get(id);
        return result == null ? null : new MapSession(result);
    }

    @Override
    public void delete(String id) {
        this.sessions.remove(id);
    }

    @Override
    public Session createSession() {
        return new MapSession();
    }
}

