/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.springframework.session.ExpiringSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoExpiringSession
implements ExpiringSession {
    private static final char DOT_COVER_CHAR = '\uf607';
    private final String id;
    private long created = System.currentTimeMillis();
    private long accessed;
    private int interval;
    private Date expireAt;
    private Map<String, Object> attrs = new HashMap<String, Object>();

    public MongoExpiringSession() {
        this(1800);
    }

    public MongoExpiringSession(int maxInactiveIntervalInSeconds) {
        this(UUID.randomUUID().toString(), maxInactiveIntervalInSeconds);
    }

    public MongoExpiringSession(String id, int maxInactiveIntervalInSeconds) {
        this.id = id;
        this.interval = maxInactiveIntervalInSeconds;
        this.setLastAccessedTime(this.created);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public <T> T getAttribute(String attributeName) {
        return (T)this.attrs.get(MongoExpiringSession.coverDot(attributeName));
    }

    @Override
    public Set<String> getAttributeNames() {
        HashSet<String> result = new HashSet<String>();
        for (String key : this.attrs.keySet()) {
            result.add(MongoExpiringSession.uncoverDot(key));
        }
        return result;
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) {
        if (attributeValue == null) {
            this.removeAttribute(MongoExpiringSession.coverDot(attributeName));
        } else {
            this.attrs.put(MongoExpiringSession.coverDot(attributeName), attributeValue);
        }
    }

    @Override
    public void removeAttribute(String attributeName) {
        this.attrs.remove(MongoExpiringSession.coverDot(attributeName));
    }

    @Override
    public long getCreationTime() {
        return this.created;
    }

    public void setCreationTime(long created) {
        this.created = created;
    }

    @Override
    public void setLastAccessedTime(long lastAccessedTime) {
        this.accessed = lastAccessedTime;
        this.expireAt = new Date(lastAccessedTime + TimeUnit.SECONDS.toMillis(this.interval));
    }

    @Override
    public long getLastAccessedTime() {
        return this.accessed;
    }

    @Override
    public void setMaxInactiveIntervalInSeconds(int interval) {
        this.interval = interval;
    }

    @Override
    public int getMaxInactiveIntervalInSeconds() {
        return this.interval;
    }

    @Override
    public boolean isExpired() {
        return new Date().after(this.expireAt);
    }

    public Date getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(Date expireAt) {
        this.expireAt = expireAt;
    }

    static String coverDot(String attributeName) {
        return attributeName.replace('.', '\uf607');
    }

    static String uncoverDot(String attributeName) {
        return attributeName.replace('\uf607', '.');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoExpiringSession that = (MongoExpiringSession)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

