/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.config.annotation;

import org.springframework.social.config.annotation.ConnectionFactoryConfigurer;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.support.ConnectionFactoryRegistry;
import org.springframework.social.connect.support.OAuth1ConnectionFactory;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.security.SocialAuthenticationServiceRegistry;
import org.springframework.social.security.provider.OAuth1AuthenticationService;
import org.springframework.social.security.provider.OAuth2AuthenticationService;
import org.springframework.social.security.provider.SocialAuthenticationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityEnabledConnectionFactoryConfigurer
implements ConnectionFactoryConfigurer {
    private SocialAuthenticationServiceRegistry registry = new SocialAuthenticationServiceRegistry();

    @Override
    public void addConnectionFactory(ConnectionFactory<?> connectionFactory) {
        this.registry.addAuthenticationService(this.wrapAsSocialAuthenticationService(connectionFactory));
    }

    public ConnectionFactoryRegistry getConnectionFactoryLocator() {
        return this.registry;
    }

    private <A> SocialAuthenticationService<A> wrapAsSocialAuthenticationService(ConnectionFactory<A> cf) {
        if (cf instanceof OAuth1ConnectionFactory) {
            return new OAuth1AuthenticationService((OAuth1ConnectionFactory)cf);
        }
        if (cf instanceof OAuth2ConnectionFactory) {
            return new OAuth2AuthenticationService((OAuth2ConnectionFactory)cf);
        }
        throw new IllegalArgumentException("The connection factory must be one of OAuth1ConnectionFactory or OAuth2ConnectionFactory");
    }
}

