/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.config.xml;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.social.config.xml.AbstractProviderConfigBeanDefinitionParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractProviderConfigNamespaceHandler
implements NamespaceHandler {
    private final Map<String, BeanDefinitionParser> parsers = new HashMap<String, BeanDefinitionParser>();

    public final void init() {
        this.loadParsers();
    }

    public final BeanDefinition parse(Element element, ParserContext parserContext) {
        String name = parserContext.getDelegate().getLocalName((Node)element);
        BeanDefinitionParser parser = this.parsers.get(name);
        if (parser == null) {
            this.loadParsers();
        }
        if (parser == null) {
            this.reportUnsupportedNodeType(name, parserContext, element);
            return null;
        }
        return parser.parse(element, parserContext);
    }

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder beanDefinitionHolder, ParserContext parserContext) {
        return beanDefinitionHolder;
    }

    protected abstract AbstractProviderConfigBeanDefinitionParser getProviderConfigBeanDefinitionParser();

    protected void loadParsers(Map<String, BeanDefinitionParser> parsers) {
    }

    private void reportUnsupportedNodeType(String name, ParserContext parserContext, Node node) {
        parserContext.getReaderContext().fatal("Twitter namespace does not support " + (node instanceof Element ? "element" : "attribute") + " [" + name + "]", (Object)node);
    }

    private void loadParsers() {
        this.parsers.put("config", this.getProviderConfigBeanDefinitionParser());
        this.loadParsers(this.parsers);
    }
}

