/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.net.URI;
import java.util.List;
import org.springframework.social.facebook.api.FacebookProfile;
import org.springframework.social.facebook.api.FriendOperations;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.social.facebook.api.impl.FacebookProfileList;
import org.springframework.social.facebook.api.impl.FriendIdList;
import org.springframework.social.facebook.api.impl.ReferenceList;
import org.springframework.social.support.URIBuilder;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FriendTemplate
extends AbstractFacebookOperations
implements FriendOperations {
    private final GraphApi graphApi;
    private final RestTemplate restTemplate;
    private static final String[] FULL_PROFILE_FIELDS = new String[]{"id", "username", "name", "first_name", "last_name", "gender", "locale", "education", "work", "email", "third_party_id", "link", "timezone", "updated_time", "verified", "about", "bio", "birthday", "location", "hometown", "interested_in", "religion", "political", "quotes", "relationship_status", "significant_other", "website"};

    public FriendTemplate(GraphApi graphApi, RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
        this.restTemplate = restTemplate;
    }

    @Override
    public List<Reference> getFriendLists() {
        return this.getFriendLists("me");
    }

    @Override
    public List<Reference> getFriendLists(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "friendlists", ReferenceList.class, new String[0]).getList();
    }

    @Override
    public Reference getFriendList(String friendListId) {
        this.requireAuthorization();
        return this.graphApi.fetchObject(friendListId, Reference.class);
    }

    @Override
    public List<Reference> getFriendListMembers(String friendListId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(friendListId, "members", ReferenceList.class, new String[0]).getList();
    }

    @Override
    public Reference createFriendList(String name) {
        return this.createFriendList("me", name);
    }

    @Override
    public Reference createFriendList(String userId, String name) {
        this.requireAuthorization();
        URI uri = URIBuilder.fromUri((String)("https://graph.facebook.com/" + userId + "/friendlists")).queryParam("name", name).build();
        return (Reference)this.restTemplate.postForObject(uri, (Object)"", Reference.class);
    }

    @Override
    public void deleteFriendList(String friendListId) {
        this.requireAuthorization();
        this.graphApi.delete(friendListId);
    }

    @Override
    public void addToFriendList(String friendListId, String friendId) {
        this.requireAuthorization();
        URI uri = URIBuilder.fromUri((String)("https://graph.facebook.com/" + friendListId + "/members/" + friendId)).build();
        this.restTemplate.postForObject(uri, (Object)"", String.class);
    }

    @Override
    public void removeFromFriendList(String friendListId, String friendId) {
        this.requireAuthorization();
        URI uri = URIBuilder.fromUri((String)("https://graph.facebook.com/" + friendListId + "/members/" + friendId)).build();
        this.restTemplate.delete(uri);
    }

    @Override
    public List<Reference> getFriends() {
        return this.getFriends("me");
    }

    @Override
    public List<String> getFriendIds() {
        return this.getFriendIds("me");
    }

    @Override
    public List<FacebookProfile> getFriendProfiles() {
        return this.getFriendProfiles("me");
    }

    @Override
    public List<Reference> getFriends(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "friends", ReferenceList.class, new String[0]).getList();
    }

    @Override
    public List<String> getFriendIds(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "friends", FriendIdList.class, "id").getList();
    }

    @Override
    public List<FacebookProfile> getFriendProfiles(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "friends", FacebookProfileList.class, FULL_PROFILE_FIELDS).getList();
    }
}

