/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.util.List;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.LikeOperations;
import org.springframework.social.facebook.api.UserLike;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.social.facebook.api.impl.UserLikeList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LikeTemplate
extends AbstractFacebookOperations
implements LikeOperations {
    private final GraphApi graphApi;

    public LikeTemplate(GraphApi graphApi, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
    }

    @Override
    public void like(String objectId) {
        this.requireAuthorization();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        this.graphApi.post(objectId, "likes", (MultiValueMap<String, String>)map);
    }

    @Override
    public void unlike(String objectId) {
        this.requireAuthorization();
        this.graphApi.delete(objectId, "likes");
    }

    @Override
    public List<UserLike> getLikes() {
        return this.getLikes("me");
    }

    @Override
    public List<UserLike> getLikes(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "likes", UserLikeList.class, new String[0]).getList();
    }

    @Override
    public List<UserLike> getBooks() {
        return this.getBooks("me");
    }

    @Override
    public List<UserLike> getBooks(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "books", UserLikeList.class, new String[0]).getList();
    }

    @Override
    public List<UserLike> getMovies() {
        return this.getMovies("me");
    }

    @Override
    public List<UserLike> getMovies(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "movies", UserLikeList.class, new String[0]).getList();
    }

    @Override
    public List<UserLike> getMusic() {
        return this.getMusic("me");
    }

    @Override
    public List<UserLike> getMusic(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "music", UserLikeList.class, new String[0]).getList();
    }

    @Override
    public List<UserLike> getTelevision() {
        return this.getTelevision("me");
    }

    @Override
    public List<UserLike> getTelevision(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "television", UserLikeList.class, new String[0]).getList();
    }

    @Override
    public List<UserLike> getActivities() {
        return this.getActivities("me");
    }

    @Override
    public List<UserLike> getActivities(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "activities", UserLikeList.class, new String[0]).getList();
    }

    @Override
    public List<UserLike> getInterests() {
        return this.getInterests("me");
    }

    @Override
    public List<UserLike> getInterests(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "interests", UserLikeList.class, new String[0]).getList();
    }
}

