/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.node.ObjectNode;
import org.springframework.social.facebook.api.LinkPost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonIgnoreProperties(value={"paging"})
class LinkPostList {
    private final List<LinkPost> list;

    @JsonCreator
    public LinkPostList(@JsonProperty(value="data") @JsonDeserialize(using=LinkPostDeserializer.class) List<LinkPost> list) {
        this.list = list;
    }

    public List<LinkPost> getList() {
        return this.list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinkPostDeserializer
    extends JsonDeserializer<List<LinkPost>> {
        private LinkPostDeserializer() {
        }

        public List<LinkPost> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setDeserializationConfig(ctxt.getConfig());
            ArrayList<LinkPost> posts = new ArrayList<LinkPost>();
            JsonNode tree = jp.readValueAsTree();
            for (ObjectNode node : tree) {
                node.put("type", "link");
                LinkPost post = (LinkPost)objectMapper.readValue((JsonNode)node, LinkPost.class);
                posts.add(post);
            }
            return posts;
        }
    }
}

