/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.node.ObjectNode;
import org.springframework.social.facebook.api.NotePost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonIgnoreProperties(value={"paging"})
class NotePostList {
    private final List<NotePost> list;

    @JsonCreator
    public NotePostList(@JsonProperty(value="data") @JsonDeserialize(using=NotePostDeserializer.class) List<NotePost> list) {
        this.list = list;
    }

    public List<NotePost> getList() {
        return this.list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotePostDeserializer
    extends JsonDeserializer<List<NotePost>> {
        private NotePostDeserializer() {
        }

        public List<NotePost> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setDeserializationConfig(ctxt.getConfig());
            ArrayList<NotePost> posts = new ArrayList<NotePost>();
            JsonNode tree = jp.readValueAsTree();
            for (ObjectNode node : tree) {
                node.put("type", "note");
                NotePost post = (NotePost)objectMapper.readValue((JsonNode)node, NotePost.class);
                posts.add(post);
            }
            return posts;
        }
    }
}

