/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.springframework.social.facebook.api.CheckinPost;
import org.springframework.social.facebook.api.Comment;
import org.springframework.social.facebook.api.LinkPost;
import org.springframework.social.facebook.api.MusicPost;
import org.springframework.social.facebook.api.NotePost;
import org.springframework.social.facebook.api.PhotoPost;
import org.springframework.social.facebook.api.Post;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.StatusPost;
import org.springframework.social.facebook.api.SwfPost;
import org.springframework.social.facebook.api.VideoPost;
import org.springframework.social.facebook.api.impl.json.CommentListDeserializer;
import org.springframework.social.facebook.api.impl.json.ReferenceListDeserializer;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="postType")
@JsonSubTypes(value={@JsonSubTypes.Type(name="checkin", value=CheckinPost.class), @JsonSubTypes.Type(name="link", value=LinkPost.class), @JsonSubTypes.Type(name="note", value=NotePost.class), @JsonSubTypes.Type(name="photo", value=PhotoPost.class), @JsonSubTypes.Type(name="status", value=StatusPost.class), @JsonSubTypes.Type(name="video", value=VideoPost.class), @JsonSubTypes.Type(name="post", value=Post.class), @JsonSubTypes.Type(name="swf", value=SwfPost.class), @JsonSubTypes.Type(name="music", value=MusicPost.class)})
@JsonIgnoreProperties(ignoreUnknown=true)
abstract class PostMixin {
    @JsonProperty(value="to")
    @JsonDeserialize(using=ReferenceListDeserializer.class)
    List<Reference> to;
    @JsonProperty(value="message")
    String message;
    @JsonProperty(value="caption")
    String caption;
    @JsonProperty(value="picture")
    String picture;
    @JsonProperty(value="link")
    String link;
    @JsonProperty(value="subject")
    String subject;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="description")
    String description;
    @JsonProperty(value="icon")
    String icon;
    @JsonProperty(value="application")
    Reference application;
    @JsonProperty(value="type")
    @JsonDeserialize(using=TypeDeserializer.class)
    Post.PostType type;
    @JsonProperty(value="likes")
    @JsonDeserialize(using=LikesCountDeserializer.class)
    int likeCount;
    @JsonProperty(value="comments")
    @JsonDeserialize(using=CommentListDeserializer.class)
    List<Comment> comments;

    @JsonCreator
    PostMixin(@JsonProperty(value="id") String id, @JsonProperty(value="from") Reference from, @JsonProperty(value="created_time") Date createdTime, @JsonProperty(value="updated_time") Date updatedTime) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LikesCountDeserializer
    extends JsonDeserializer<Integer> {
        private LikesCountDeserializer() {
        }

        public Integer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = jp.readValueAsTree();
            return tree.get("count").getIntValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeDeserializer
    extends JsonDeserializer<Post.PostType> {
        private TypeDeserializer() {
        }

        public Post.PostType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return Post.PostType.valueOf(jp.getText().toUpperCase());
        }
    }
}

