/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Map;
import org.springframework.social.facebook.api.CoverPhoto;
import org.springframework.social.facebook.api.Location;
import org.springframework.social.facebook.api.impl.json.FacebookObjectMixin;
import org.springframework.social.facebook.api.impl.json.PictureDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class PageMixin
extends FacebookObjectMixin {
    @JsonProperty(value="description")
    String description;
    @JsonProperty(value="about")
    String about;
    @JsonProperty(value="location")
    @JsonDeserialize(using=LocationDeserializer.class)
    Location location;
    @JsonProperty(value="website")
    String website;
    @JsonProperty(value="picture")
    @JsonDeserialize(using=PictureDeserializer.class)
    String picture;
    @JsonProperty(value="cover")
    CoverPhoto cover;
    @JsonProperty(value="phone")
    String phone;
    @JsonProperty(value="affiliation")
    String affiliation;
    @JsonProperty(value="company_overview")
    String companyOverview;
    @JsonProperty(value="likes")
    int likes;
    @JsonProperty(value="talking_about_count")
    int talkingAboutCount;
    @JsonProperty(value="checkins")
    int checkins;
    @JsonProperty(value="can_post")
    boolean canPost;
    @JsonProperty(value="is_published")
    private boolean isPublished;
    @JsonProperty(value="is_community_page")
    private boolean isCommunityPage;
    @JsonProperty(value="has_added_app")
    private boolean hasAddedApp;
    @JsonProperty(value="hours")
    private Map<String, String> hours;

    @JsonCreator
    PageMixin(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="link") String location, @JsonProperty(value="category") String category) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocationDeserializer
    extends JsonDeserializer<Location> {
        private LocationDeserializer() {
        }

        public Location deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                return (Location)jp.readValueAs(Location.class);
            }
            return new Location(jp.getText());
        }
    }
}

