/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Date;
import org.springframework.social.facebook.api.Event;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.impl.json.FacebookObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class EventMixin
extends FacebookObjectMixin {
    @JsonProperty(value="description")
    String description;
    @JsonProperty(value="location")
    String location;

    @JsonCreator
    EventMixin(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="owner") Reference owner, @JsonProperty(value="privacy") @JsonDeserialize(using=PrivacyDeserializer.class) Event.Privacy privacy, @JsonProperty(value="start_time") Date startTime, @JsonProperty(value="end_time") Date endTime, @JsonProperty(value="updated_time") Date updatedTime) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrivacyDeserializer
    extends JsonDeserializer<Event.Privacy> {
        private PrivacyDeserializer() {
        }

        public Event.Privacy deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return Event.Privacy.valueOf(jp.getText().toUpperCase());
        }
    }
}

