/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api;

import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageUpdate {
    private final String pageId;
    private String about;
    private String bio;
    private String cover;
    private String name;
    private Integer offsetX;
    private Integer offsetY;
    private Float zoomScaleX;
    private Float zoomScaleY;
    private Float focusX;
    private Float focusY;

    public PageUpdate(String pageId) {
        this.pageId = pageId;
    }

    public String getPageId() {
        return this.pageId;
    }

    public PageUpdate about(String about) {
        this.about = about;
        return this;
    }

    public PageUpdate bio(String bio) {
        this.bio = bio;
        return this;
    }

    public PageUpdate cover(String cover, Integer offsetX, Integer offsetY, Float zoomScaleX, Float zoomScaleY, Float focusX, Float focusY) {
        this.cover = cover;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.zoomScaleX = zoomScaleX;
        this.zoomScaleY = zoomScaleY;
        this.focusX = focusX;
        this.focusY = focusY;
        return this;
    }

    public PageUpdate name(String name) {
        this.name = name;
        return this;
    }

    public MultiValueMap<String, Object> toRequestParameters() {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (this.about != null) {
            parameters.add((Object)"about", (Object)this.about);
        }
        if (this.bio != null) {
            parameters.add((Object)"bio", (Object)this.bio);
        }
        if (this.cover != null) {
            parameters.add((Object)"cover", (Object)this.cover);
        }
        if (this.name != null) {
            parameters.add((Object)"name", (Object)this.name);
        }
        if (this.offsetX != null) {
            parameters.add((Object)"offset_x", (Object)this.offsetX.toString());
        }
        if (this.offsetY != null) {
            parameters.add((Object)"offset_y", (Object)this.offsetY.toString());
        }
        if (this.zoomScaleX != null) {
            parameters.add((Object)"zoom_scale_x", (Object)this.zoomScaleX.toString());
        }
        if (this.zoomScaleY != null) {
            parameters.add((Object)"zoom_scale_y", (Object)this.zoomScaleY.toString());
        }
        if (this.focusX != null) {
            parameters.add((Object)"focus_x", (Object)this.focusX.toString());
        }
        if (this.focusY != null) {
            parameters.add((Object)"focus_y", (Object)this.focusY.toString());
        }
        return parameters;
    }
}

