/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.social.UncategorizedApiException;
import org.springframework.social.facebook.api.FacebookLink;
import org.springframework.social.facebook.api.FeedOperations;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.PagedList;
import org.springframework.social.facebook.api.PagingParameters;
import org.springframework.social.facebook.api.Post;
import org.springframework.social.facebook.api.PostData;
import org.springframework.social.facebook.api.impl.PagedListUtils;
import org.springframework.social.support.URIBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

class FeedTemplate
implements FeedOperations {
    private static final PagingParameters FIRST_PAGE = new PagingParameters(25, null, null, null);
    private final GraphApi graphApi;
    private ObjectMapper objectMapper;
    private final RestTemplate restTemplate;
    private static final String[] ALL_POST_FIELDS = new String[]{"id", "actions", "admin_creator", "application", "caption", "created_time", "description", "from", "icon", "is_hidden", "is_published", "link", "message", "message_tags", "name", "object_id", "picture", "place", "privacy", "properties", "source", "status_type", "story", "to", "type", "updated_time", "with_tags", "shares"};

    public FeedTemplate(GraphApi graphApi, RestTemplate restTemplate, ObjectMapper objectMapper) {
        this.graphApi = graphApi;
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
    }

    @Override
    public PagedList<Post> getFeed() {
        return this.getFeed("me", FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getFeed(PagingParameters pagedListParameters) {
        return this.getFeed("me", pagedListParameters);
    }

    @Override
    public PagedList<Post> getFeed(String ownerId) {
        return this.getFeed(ownerId, FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getFeed(String ownerId, PagingParameters pagedListParameters) {
        JsonNode responseNode = this.fetchConnectionList(this.graphApi.getBaseGraphApiUrl() + ownerId + "/feed", pagedListParameters);
        return this.deserializeList(responseNode, null, Post.class);
    }

    @Override
    public PagedList<Post> getHomeFeed() {
        return this.getHomeFeed(FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getHomeFeed(PagingParameters pagedListParameters) {
        JsonNode responseNode = this.fetchConnectionList(this.graphApi.getBaseGraphApiUrl() + "me/home", pagedListParameters);
        return this.deserializeList(responseNode, null, Post.class);
    }

    @Override
    public PagedList<Post> getStatuses() {
        return this.getStatuses("me", FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getStatuses(PagingParameters pagedListParameters) {
        return this.getStatuses("me", pagedListParameters);
    }

    @Override
    public PagedList<Post> getStatuses(String userId) {
        return this.getStatuses(userId, FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getStatuses(String userId, PagingParameters pagedListParameters) {
        JsonNode responseNode = this.fetchConnectionList(this.graphApi.getBaseGraphApiUrl() + userId + "/statuses", pagedListParameters);
        return this.deserializeList(responseNode, "status", Post.class);
    }

    @Override
    public PagedList<Post> getLinks() {
        return this.getLinks("me", FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getLinks(PagingParameters pagedListParameters) {
        return this.getLinks("me", pagedListParameters);
    }

    @Override
    public PagedList<Post> getLinks(String ownerId) {
        return this.getLinks(ownerId, FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getLinks(String ownerId, PagingParameters pagedListParameters) {
        JsonNode responseNode = this.fetchConnectionList(this.graphApi.getBaseGraphApiUrl() + ownerId + "/links", pagedListParameters);
        return this.deserializeList(responseNode, "link", Post.class);
    }

    @Override
    public PagedList<Post> getPosts() {
        return this.getPosts("me", FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getPosts(PagingParameters pagedListParameters) {
        return this.getPosts("me", pagedListParameters);
    }

    @Override
    public PagedList<Post> getPosts(String ownerId) {
        return this.getPosts(ownerId, FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getPosts(String ownerId, PagingParameters pagedListParameters) {
        JsonNode responseNode = this.fetchConnectionList(this.graphApi.getBaseGraphApiUrl() + ownerId + "/posts", pagedListParameters);
        return this.deserializeList(responseNode, null, Post.class);
    }

    @Override
    public PagedList<Post> getTagged() {
        return this.getTagged("me", FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getTagged(PagingParameters pagedListParameters) {
        return this.getTagged("me", pagedListParameters);
    }

    @Override
    public PagedList<Post> getTagged(String ownerId) {
        return this.getTagged(ownerId, FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getTagged(String ownerId, PagingParameters pagedListParameters) {
        JsonNode responseNode = this.fetchConnectionList(this.graphApi.getBaseGraphApiUrl() + ownerId + "/tagged", pagedListParameters);
        return this.deserializeList(responseNode, null, Post.class);
    }

    @Override
    public Post getPost(String entryId) {
        ObjectNode responseNode = (ObjectNode)this.restTemplate.getForObject(this.graphApi.getBaseGraphApiUrl() + entryId, JsonNode.class, new Object[0]);
        return this.deserializePost(null, Post.class, responseNode);
    }

    @Override
    public String updateStatus(String message) {
        return this.post("me", message);
    }

    @Override
    public String postLink(String message, FacebookLink link) {
        return this.postLink("me", message, link);
    }

    @Override
    public String postLink(String ownerId, String message, FacebookLink link) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.set((Object)"link", (Object)link.getLink());
        map.set((Object)"name", (Object)link.getName());
        map.set((Object)"caption", (Object)link.getCaption());
        map.set((Object)"description", (Object)link.getDescription());
        map.set((Object)"message", (Object)message);
        return this.graphApi.publish(ownerId, "feed", (MultiValueMap<String, Object>)map);
    }

    @Override
    public String post(PostData post) {
        return this.graphApi.publish(post.getTargetFeedId(), "feed", post.toRequestParameters());
    }

    @Override
    public String post(String ownerId, String message) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.set((Object)"message", (Object)message);
        return this.graphApi.publish(ownerId, "feed", (MultiValueMap<String, Object>)map);
    }

    @Override
    public void deletePost(String id) {
        this.graphApi.delete(id);
    }

    @Override
    public PagedList<Post> getCheckins() {
        return this.getCheckins(new PagingParameters(25, 0, null, null));
    }

    @Override
    public PagedList<Post> getCheckins(PagingParameters pagedListParameters) {
        MultiValueMap<String, String> params = PagedListUtils.getPagingParameters(pagedListParameters);
        params.set((Object)"with", (Object)"location");
        return this.graphApi.fetchConnections("me", "posts", Post.class, params);
    }

    @Override
    public Post getCheckin(String checkinId) {
        return this.graphApi.fetchObject(checkinId, Post.class);
    }

    private JsonNode fetchConnectionList(String baseUri, PagingParameters pagedListParameters) {
        URIBuilder uriBuilder = URIBuilder.fromUri((String)baseUri);
        uriBuilder = this.appendPagedListParameters(pagedListParameters, uriBuilder);
        uriBuilder.queryParam("fields", StringUtils.arrayToCommaDelimitedString((Object[])ALL_POST_FIELDS));
        URI uri = uriBuilder.build();
        JsonNode responseNode = (JsonNode)this.restTemplate.getForObject(uri, JsonNode.class);
        return responseNode;
    }

    private <T> PagedList<T> deserializeList(JsonNode jsonNode, String postType, Class<T> type) {
        JsonNode dataNode = jsonNode.get("data");
        ArrayList<T> posts = new ArrayList<T>();
        Iterator iterator = dataNode.iterator();
        while (iterator.hasNext()) {
            posts.add(this.deserializePost(postType, type, (ObjectNode)iterator.next()));
        }
        if (jsonNode.has("paging")) {
            JsonNode pagingNode = jsonNode.get("paging");
            PagingParameters previousPage = PagedListUtils.getPagedListParameters(pagingNode, "previous");
            PagingParameters nextPage = PagedListUtils.getPagedListParameters(pagingNode, "next");
            return new PagedList(posts, previousPage, nextPage);
        }
        return new PagedList(posts, null, null);
    }

    private <T> T deserializePost(String postType, Class<T> type, ObjectNode node) {
        try {
            if (postType == null) {
                postType = this.determinePostType(node);
            }
            node.put("postType", postType);
            node.put("type", postType);
            return (T)this.objectMapper.reader(type).readValue(node.toString());
        }
        catch (IOException shouldntHappen) {
            throw new UncategorizedApiException("facebook", "Error deserializing " + postType + " post", (Throwable)shouldntHappen);
        }
    }

    private String determinePostType(ObjectNode node) {
        if (node.has("type")) {
            try {
                String type = node.get("type").textValue();
                Post.PostType.valueOf(type.toUpperCase());
                return type;
            }
            catch (IllegalArgumentException e) {
                return "post";
            }
        }
        return "post";
    }

    private URIBuilder appendPagedListParameters(PagingParameters pagedListParameters, URIBuilder uriBuilder) {
        if (pagedListParameters.getLimit() != null) {
            uriBuilder = uriBuilder.queryParam("limit", String.valueOf(pagedListParameters.getLimit()));
        }
        if (pagedListParameters.getSince() != null) {
            uriBuilder = uriBuilder.queryParam("since", String.valueOf(pagedListParameters.getSince()));
        }
        if (pagedListParameters.getUntil() != null) {
            uriBuilder = uriBuilder.queryParam("until", String.valueOf(pagedListParameters.getUntil()));
        }
        if (pagedListParameters.getAfter() != null) {
            uriBuilder = uriBuilder.queryParam("after", String.valueOf(pagedListParameters.getAfter()));
        }
        if (pagedListParameters.getBefore() != null) {
            uriBuilder = uriBuilder.queryParam("before", String.valueOf(pagedListParameters.getBefore()));
        }
        if (pagedListParameters.getPagingToken() != null) {
            uriBuilder = uriBuilder.queryParam("__paging_token", String.valueOf(pagedListParameters.getPagingToken()));
        }
        return uriBuilder;
    }
}

