/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.LikeOperations;
import org.springframework.social.facebook.api.Page;
import org.springframework.social.facebook.api.PagedList;
import org.springframework.social.facebook.api.PagingParameters;
import org.springframework.social.facebook.api.Reference;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class LikeTemplate
implements LikeOperations {
    private final GraphApi graphApi;
    private static final String PAGE_FIELDS = "id,name,category,description,location,website,picture,phone,affiliation,company_overview,likes,checkins,cover";

    public LikeTemplate(GraphApi graphApi) {
        this.graphApi = graphApi;
    }

    @Override
    public void like(String objectId) {
        this.graphApi.post(objectId, "likes", (MultiValueMap<String, Object>)new LinkedMultiValueMap());
    }

    @Override
    public void unlike(String objectId) {
        this.graphApi.delete(objectId, "likes");
    }

    @Override
    public PagedList<Reference> getLikes(String objectId) {
        return this.graphApi.fetchConnections(objectId, "likes", Reference.class, new String[0]);
    }

    @Override
    public PagedList<Reference> getLikes(String objectId, PagingParameters pagingParameters) {
        return this.graphApi.fetchConnections(objectId, "likes", Reference.class, pagingParameters.toMap());
    }

    @Override
    public PagedList<Page> getPagesLiked() {
        return this.getPagesLiked("me");
    }

    @Override
    public PagedList<Page> getPagesLiked(PagingParameters pagingParameters) {
        return this.getPagesLiked("me", pagingParameters);
    }

    @Override
    public PagedList<Page> getPagesLiked(String userId) {
        return this.graphApi.fetchConnections(userId, "likes", Page.class, PAGE_FIELDS);
    }

    @Override
    public PagedList<Page> getPagesLiked(String userId, PagingParameters pagingParameters) {
        return this.graphApi.fetchConnections(userId, "likes", Page.class, pagingParameters.toMap(), PAGE_FIELDS);
    }

    @Override
    public PagedList<Page> getBooks() {
        return this.getBooks("me");
    }

    @Override
    public PagedList<Page> getBooks(PagingParameters pagingParameters) {
        return this.getBooks("me", pagingParameters);
    }

    @Override
    public PagedList<Page> getBooks(String userId) {
        return this.graphApi.fetchConnections(userId, "books", Page.class, PAGE_FIELDS);
    }

    @Override
    public PagedList<Page> getBooks(String userId, PagingParameters pagingParameters) {
        return this.graphApi.fetchConnections(userId, "books", Page.class, pagingParameters.toMap(), PAGE_FIELDS);
    }

    @Override
    public PagedList<Page> getMovies() {
        return this.getMovies("me");
    }

    @Override
    public PagedList<Page> getMovies(PagingParameters pagingParameters) {
        return this.getMovies("me", pagingParameters);
    }

    @Override
    public PagedList<Page> getMovies(String userId) {
        return this.graphApi.fetchConnections(userId, "movies", Page.class, PAGE_FIELDS);
    }

    @Override
    public PagedList<Page> getMovies(String userId, PagingParameters pagingParameters) {
        return this.graphApi.fetchConnections(userId, "movies", Page.class, pagingParameters.toMap(), PAGE_FIELDS);
    }

    @Override
    public PagedList<Page> getMusic() {
        return this.getMusic("me");
    }

    @Override
    public PagedList<Page> getMusic(PagingParameters pagingParameters) {
        return this.getMusic("me", pagingParameters);
    }

    @Override
    public PagedList<Page> getMusic(String userId) {
        return this.graphApi.fetchConnections(userId, "music", Page.class, PAGE_FIELDS);
    }

    @Override
    public PagedList<Page> getMusic(String userId, PagingParameters pagingParameters) {
        return this.graphApi.fetchConnections(userId, "music", Page.class, pagingParameters.toMap(), PAGE_FIELDS);
    }

    @Override
    public PagedList<Page> getTelevision() {
        return this.getTelevision("me");
    }

    @Override
    public PagedList<Page> getTelevision(PagingParameters pagingParameters) {
        return this.getTelevision("me", pagingParameters);
    }

    @Override
    public PagedList<Page> getTelevision(String userId) {
        return this.graphApi.fetchConnections(userId, "television", Page.class, PAGE_FIELDS);
    }

    @Override
    public PagedList<Page> getTelevision(String userId, PagingParameters pagingParameters) {
        return this.graphApi.fetchConnections(userId, "television", Page.class, pagingParameters.toMap(), PAGE_FIELDS);
    }

    @Override
    public PagedList<Page> getGames() {
        return this.getGames("me");
    }

    @Override
    public PagedList<Page> getGames(PagingParameters pagingParameters) {
        return this.getGames("me", pagingParameters);
    }

    @Override
    public PagedList<Page> getGames(String userId) {
        return this.graphApi.fetchConnections(userId, "games", Page.class, PAGE_FIELDS);
    }

    @Override
    public PagedList<Page> getGames(String userId, PagingParameters pagingParameters) {
        return this.graphApi.fetchConnections(userId, "games", Page.class, pagingParameters.toMap(), PAGE_FIELDS);
    }
}

