/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import org.springframework.social.facebook.api.CountedList;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.SocialContextOperations;
import org.springframework.social.support.URIBuilder;
import org.springframework.web.client.RestOperations;

class SocialContextTemplate
implements SocialContextOperations {
    private static final int LIMIT = 25;
    private final RestOperations rest;
    private GraphApi graphApi;

    @Deprecated
    public SocialContextTemplate(RestOperations rest) {
        this.rest = rest;
    }

    public SocialContextTemplate(GraphApi graphApi, RestOperations rest) {
        this.graphApi = graphApi;
        this.rest = rest;
    }

    @Override
    public CountedList<Reference> getMutualFriends(String userId) {
        return this.getSocialContext(userId, "mutual_friends", 25);
    }

    @Override
    public CountedList<Reference> getMutualFriends(String userId, int limit) {
        return this.getSocialContext(userId, "mutual_friends", limit);
    }

    @Override
    public CountedList<Reference> getAllMutualFriends(String userId) {
        return this.getSocialContext(userId, "all_mutual_friends", 25);
    }

    @Override
    public CountedList<Reference> getAllMutualFriends(String userId, int limit) {
        return this.getSocialContext(userId, "all_mutual_friends", limit);
    }

    @Override
    public CountedList<Reference> getMutualLikes(String userId) {
        return this.getSocialContext(userId, "mutual_likes", 25);
    }

    @Override
    public CountedList<Reference> getMutualLikes(String userId, int limit) {
        return this.getSocialContext(userId, "mutual_likes", limit);
    }

    @Override
    public CountedList<Reference> getFriendsUsingApp(String appId) {
        return this.getFriendsUsingApp(appId, 25);
    }

    @Override
    public CountedList<Reference> getFriendsUsingApp(String appId, int limit) {
        return this.getSocialContext(appId, "friends_using_app", limit);
    }

    @Override
    public CountedList<Reference> getFriendsWhoLike(String objectId) {
        return this.getFriendsWhoLike(objectId, 25);
    }

    @Override
    public CountedList<Reference> getFriendsWhoLike(String objectId, int limit) {
        return this.getSocialContext(objectId, "friends_who_like", limit);
    }

    @Override
    public CountedList<Reference> getFriendsWhoWatched(String videoId) {
        return this.getFriendsWhoWatched(videoId, 25);
    }

    @Override
    public CountedList<Reference> getFriendsWhoWatched(String videoId, int limit) {
        return this.getSocialContext(videoId, "video_watch_friends", limit);
    }

    @Override
    public CountedList<Reference> getFriendsWhoListenTo(String objectId) {
        return this.getFriendsWhoListenTo(objectId, 25);
    }

    @Override
    public CountedList<Reference> getFriendsWhoListenTo(String objectId, int limit) {
        return this.getSocialContext(objectId, "music_listen_friends", limit);
    }

    @Override
    public CountedList<Reference> getFriendsTaggedAt(String placeId) {
        return this.getFriendsTaggedAt(placeId, 25);
    }

    @Override
    public CountedList<Reference> getFriendsTaggedAt(String placeId, int limit) {
        return this.getSocialContext(placeId, "friends_tagged_at", limit);
    }

    private CountedList<Reference> getSocialContext(String userId, String context, int limit) {
        URIBuilder uriBuilder = URIBuilder.fromUri((String)(this.graphApi.getBaseGraphApiUrl() + userId)).queryParam("fields", "context.fields(" + context + ".limit(" + limit + "))");
        JsonNode responseNode = (JsonNode)this.rest.getForObject(uriBuilder.build(), JsonNode.class);
        JsonNode contextRootNode = responseNode.get("context");
        if (contextRootNode == null) {
            return new CountedList<Reference>(new ArrayList(0), 0);
        }
        JsonNode contextNode = contextRootNode.get(context);
        if (contextNode == null) {
            return new CountedList<Reference>(new ArrayList(0), 0);
        }
        ArrayNode dataNode = (ArrayNode)contextNode.get("data");
        ArrayList<Reference> results = new ArrayList<Reference>(dataNode.size());
        for (JsonNode itemNode : dataNode) {
            results.add(new Reference(itemNode.get("id").textValue(), itemNode.get("name").textValue()));
        }
        Integer totalCount = contextNode.has("summary") && contextNode.get("summary").has("total_count") ? Integer.valueOf(contextNode.get("summary").get("total_count").intValue()) : null;
        return new CountedList<Reference>(results, totalCount);
    }
}

