/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.ImageType;
import org.springframework.social.facebook.api.PagedList;
import org.springframework.social.facebook.api.Permission;
import org.springframework.social.facebook.api.PlaceTag;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.User;
import org.springframework.social.facebook.api.UserIdForApp;
import org.springframework.social.facebook.api.UserOperations;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

class UserTemplate
implements UserOperations {
    private final GraphApi graphApi;
    private final RestTemplate restTemplate;

    public UserTemplate(GraphApi graphApi, RestTemplate restTemplate) {
        this.graphApi = graphApi;
        this.restTemplate = restTemplate;
    }

    @Override
    public User getUserProfile() {
        return this.getUserProfile("me");
    }

    @Override
    public User getUserProfile(String facebookId) {
        return this.graphApi.fetchObject(facebookId, User.class, PROFILE_FIELDS);
    }

    @Override
    public byte[] getUserProfileImage() {
        return this.getUserProfileImage("me", ImageType.NORMAL);
    }

    @Override
    public byte[] getUserProfileImage(String userId) {
        return this.getUserProfileImage(userId, ImageType.NORMAL);
    }

    @Override
    public byte[] getUserProfileImage(ImageType imageType) {
        return this.getUserProfileImage("me", imageType);
    }

    @Override
    public byte[] getUserProfileImage(String userId, ImageType imageType) {
        return this.graphApi.fetchImage(userId, "picture", imageType);
    }

    @Override
    public byte[] getUserProfileImage(Integer width, Integer height) {
        return this.getUserProfileImage("me", width, height);
    }

    @Override
    public byte[] getUserProfileImage(String userId, Integer width, Integer height) {
        return this.graphApi.fetchImage(userId, "picture", width, height);
    }

    @Override
    public List<Permission> getUserPermissions() {
        JsonNode responseNode = (JsonNode)this.restTemplate.getForObject(this.graphApi.getBaseGraphApiUrl() + "me/permissions", JsonNode.class, new Object[0]);
        return this.deserializePermissionsNodeToList(responseNode);
    }

    @Override
    public List<UserIdForApp> getIdsForBusiness() {
        return this.graphApi.fetchConnections("me", "ids_for_business", UserIdForApp.class, new String[0]);
    }

    @Override
    public List<PlaceTag> getTaggedPlaces() {
        return this.graphApi.fetchConnections("me", "tagged_places", PlaceTag.class, new String[0]);
    }

    @Override
    public PagedList<Reference> search(String query) {
        LinkedMultiValueMap queryMap = new LinkedMultiValueMap();
        queryMap.add((Object)"q", (Object)query);
        queryMap.add((Object)"type", (Object)"user");
        return this.graphApi.fetchConnections("search", null, Reference.class, (MultiValueMap<String, String>)queryMap);
    }

    private List<Permission> deserializePermissionsNodeToList(JsonNode jsonNode) {
        JsonNode dataNode = jsonNode.get("data");
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        Iterator elementIt = dataNode.elements();
        while (elementIt.hasNext()) {
            JsonNode permissionsElement = (JsonNode)elementIt.next();
            String name = permissionsElement.get("permission").asText();
            String status = permissionsElement.get("status").asText();
            permissions.add(new Permission(name, status));
        }
        return permissions;
    }
}

