/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.connect;

import org.springframework.social.facebook.api.Facebook;
import org.springframework.social.facebook.api.impl.FacebookTemplate;
import org.springframework.social.oauth2.AbstractOAuth2ServiceProvider;
import org.springframework.social.oauth2.OAuth2Operations;
import org.springframework.social.oauth2.OAuth2Template;

public class FacebookServiceProvider
extends AbstractOAuth2ServiceProvider<Facebook> {
    private String appNamespace;
    private String appSecret;
    private String appId;
    private static final String API_VERSION = "2.8";
    private static final String GRAPH_API_URL = "https://graph.facebook.com/v2.8/";

    public FacebookServiceProvider(String appId, String appSecret, String appNamespace) {
        super((OAuth2Operations)FacebookServiceProvider.getOAuth2Template(appId, appSecret));
        this.appNamespace = appNamespace;
        this.appSecret = appSecret;
        this.appId = appId;
    }

    private static OAuth2Template getOAuth2Template(String appId, String appSecret) {
        OAuth2Template oAuth2Template = new OAuth2Template(appId, appSecret, "https://www.facebook.com/v2.8/dialog/oauth", "https://graph.facebook.com/v2.8/oauth/access_token");
        oAuth2Template.setUseParametersForClientAuthentication(true);
        return oAuth2Template;
    }

    public Facebook getApi(String accessToken) {
        return new FacebookTemplate(accessToken, this.appNamespace, this.appId, this.appSecret);
    }
}

