/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.drive.impl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.social.google.api.drive.DriveFileQueryBuilder;
import org.springframework.social.google.api.drive.DriveFilesPage;
import org.springframework.social.google.api.query.impl.ApiQueryBuilderImpl;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DriveFileQueryBuilderImpl
extends ApiQueryBuilderImpl<DriveFileQueryBuilder, DriveFilesPage>
implements DriveFileQueryBuilder {
    private static final String TITLE = "title";
    private static final String FULL_TEXT = "fullText";
    private static final String MIME_TYPE = "mimeType";
    private static final String MODIFIED_DATE = "modifiedDate";
    private static final String LAST_VIEWED_BY_ME_DATE = "lastViewedByMeDate";
    private static final String TRASHED = "trashed";
    private static final String STARRED = "starred";
    private static final String HIDDEN = "hidden";
    private static final String PARENTS = "parents";
    private static final String OWNERS = "owners";
    private static final String WRITERS = "writers";
    private static final String READERS = "readers";
    private static final String SHARED_WITH_ME = "sharedWithMe";
    private static final String CONTAINS = " contains ";
    private static final String IN = " in ";
    private static final String EQ = "=";
    private static final String NE = "!=";
    private static final String GT = ">";
    private static final String GE = ">=";
    private static final String LT = "<";
    private static final String LE = "<=";
    private static final String NOT = "not ";
    private static final String AND = " and ";
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private boolean negate;
    private List<String> qTerms = new ArrayList<String>();

    DriveFileQueryBuilderImpl(RestTemplate restTemplate) {
        super("https://www.googleapis.com/drive/v2/files/", DriveFilesPage.class, restTemplate);
    }

    private DriveFileQueryBuilder addStringCompareTerm(String field, String operator, String value) {
        this.qTerms.add(field + operator + '\'' + value + '\'');
        return this;
    }

    private DriveFileQueryBuilder addDateCompareTerm(String field, String operator, Date value) {
        return this.addStringCompareTerm(field, operator, dateFormat.format(value));
    }

    private DriveFileQueryBuilder addBooleanTerm(String field, boolean value) {
        this.qTerms.add(field + EQ + value);
        return this;
    }

    private DriveFileQueryBuilder addInTerm(String field, String value) {
        this.qTerms.add('\'' + value + '\'' + IN + field);
        return this;
    }

    @Override
    public DriveFileQueryBuilder not() {
        this.negate = true;
        return this;
    }

    @Override
    public DriveFileQueryBuilder titleIs(String title) {
        return this.addStringCompareTerm(TITLE, EQ, title);
    }

    @Override
    public DriveFileQueryBuilder titleContains(String text) {
        return this.addStringCompareTerm(TITLE, CONTAINS, text);
    }

    @Override
    public DriveFileQueryBuilder fullTextContains(String text) {
        return this.addStringCompareTerm(FULL_TEXT, CONTAINS, text);
    }

    @Override
    public DriveFileQueryBuilder mimeTypeIs(String mimeType) {
        return this.addStringCompareTerm(MIME_TYPE, EQ, mimeType);
    }

    @Override
    public DriveFileQueryBuilder mimeTypeIsNot(String mimeType) {
        return this.addStringCompareTerm(MIME_TYPE, NE, mimeType);
    }

    @Override
    public DriveFileQueryBuilder modifiedDateIs(Date date) {
        return this.addDateCompareTerm(MODIFIED_DATE, EQ, date);
    }

    @Override
    public DriveFileQueryBuilder modifiedDateIsOrBefore(Date date) {
        return this.addDateCompareTerm(MODIFIED_DATE, LE, date);
    }

    @Override
    public DriveFileQueryBuilder modifiedDateBefore(Date date) {
        return this.addDateCompareTerm(MODIFIED_DATE, LT, date);
    }

    @Override
    public DriveFileQueryBuilder modifiedDateIsOrAfter(Date date) {
        return this.addDateCompareTerm(MODIFIED_DATE, GE, date);
    }

    @Override
    public DriveFileQueryBuilder modifiedDateAfter(Date date) {
        return this.addDateCompareTerm(MODIFIED_DATE, GT, date);
    }

    @Override
    public DriveFileQueryBuilder lastViewedByMeIs(Date date) {
        return this.addDateCompareTerm(LAST_VIEWED_BY_ME_DATE, EQ, date);
    }

    @Override
    public DriveFileQueryBuilder lastViewedByMeIsOrBefore(Date date) {
        return this.addDateCompareTerm(LAST_VIEWED_BY_ME_DATE, LE, date);
    }

    @Override
    public DriveFileQueryBuilder lastViewedByMeBefore(Date date) {
        return this.addDateCompareTerm(LAST_VIEWED_BY_ME_DATE, LT, date);
    }

    @Override
    public DriveFileQueryBuilder lastViewedByMeIsOrAfter(Date date) {
        return this.addDateCompareTerm(LAST_VIEWED_BY_ME_DATE, GE, date);
    }

    @Override
    public DriveFileQueryBuilder lastViewedByMeAfter(Date date) {
        return this.addDateCompareTerm(LAST_VIEWED_BY_ME_DATE, GT, date);
    }

    @Override
    public DriveFileQueryBuilder trashed(boolean trashed) {
        return this.addBooleanTerm(TRASHED, trashed);
    }

    @Override
    public DriveFileQueryBuilder starred(boolean starred) {
        return this.addBooleanTerm(STARRED, starred);
    }

    @Override
    public DriveFileQueryBuilder hidden(boolean hidden) {
        return this.addBooleanTerm(HIDDEN, hidden);
    }

    @Override
    public DriveFileQueryBuilder parentIs(String id) {
        return this.addInTerm(PARENTS, id);
    }

    @Override
    public DriveFileQueryBuilder ownerIs(String email) {
        return this.addInTerm(OWNERS, email);
    }

    @Override
    public DriveFileQueryBuilder writerIs(String email) {
        return this.addInTerm(WRITERS, email);
    }

    @Override
    public DriveFileQueryBuilder readerIs(String email) {
        return this.addInTerm(READERS, email);
    }

    @Override
    public DriveFileQueryBuilder sharedWithMe() {
        this.qTerms.add(SHARED_WITH_ME);
        return this;
    }

    @Override
    public DriveFileQueryBuilder isFolder() {
        return this.mimeTypeIs("application/vnd.google-apps.folder");
    }

    @Override
    public DriveFileQueryBuilder isFile() {
        return this.mimeTypeIsNot("application/vnd.google-apps.folder");
    }

    @Override
    protected String build() {
        if (!this.qTerms.isEmpty()) {
            StringBuilder qb = new StringBuilder(StringUtils.collectionToDelimitedString(this.qTerms, (String)AND));
            if (this.negate) {
                qb.insert(0, NOT);
            }
            String encoded = DriveFileQueryBuilderImpl.encode(qb.toString());
            this.appendQueryParam("q", encoded);
        }
        return super.build();
    }
}

