/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.social.linkedin.api.CodeAndName;
import org.springframework.social.linkedin.api.Company;
import org.springframework.social.linkedin.api.impl.json.StringListDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class CompanyMixin {
    @JsonProperty(value="industry")
    String industry;
    @JsonProperty(value="size")
    String size;
    @JsonProperty(value="type")
    String type;
    @JsonProperty
    String blogRssUrl;
    @JsonProperty
    CodeAndName companyType;
    @JsonProperty
    String description;
    @JsonProperty
    @JsonDeserialize(using=StringListDeserializer.class)
    List<String> emailDomains;
    @JsonProperty
    CodeAndName employeeCountRange;
    @JsonProperty
    int foundedYear;
    @JsonProperty
    @JsonDeserialize(using=CompanyLocationListDeserializer.class)
    List<Company.CompanyLocation> locations;
    @JsonProperty
    String logoUrl;
    @JsonProperty
    int numFollowers;
    @JsonProperty
    @JsonDeserialize(using=StringListDeserializer.class)
    List<String> specialties;
    @JsonProperty
    String squareLogoUrl;
    @JsonProperty
    CodeAndName status;
    @JsonProperty
    CodeAndName stockExchange;
    @JsonProperty
    String ticker;
    @JsonProperty
    String twitterId;
    @JsonProperty
    String universalName;
    @JsonProperty
    String websiteUrl;

    @JsonCreator
    CompanyMixin(@JsonProperty(value="id") int id, @JsonProperty(value="name") String name) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompanyLocationListDeserializer
    extends JsonDeserializer<List<Company.CompanyLocation>> {
        private CompanyLocationListDeserializer() {
        }

        public List<Company.CompanyLocation> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken() && (dataNode = jp.readValueAsTree().get("values")) != null) {
                return (List)mapper.readValue(dataNode, (TypeReference)new TypeReference<List<Company.CompanyLocation>>(){});
            }
            return null;
        }
    }
}

