/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.social.linkedin.api.Group;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class GroupMixin {
    @JsonProperty
    Boolean allowMemberInvites;
    @JsonProperty
    @JsonDeserialize(using=GroupCategoryDeserializer.class)
    Group.GroupCategory category;
    @JsonProperty
    @JsonDeserialize(using=GroupCountDeserializer.class)
    List<Group.GroupCount> countsByCategory;
    @JsonProperty
    String description;
    @JsonProperty
    Boolean isOpenToNonMembers;
    @JsonProperty
    String largeLogoUrl;
    @JsonProperty
    String locale;
    @JsonProperty
    Group.GroupPosts posts;
    @JsonProperty
    Group.GroupRelation relationToViewer;
    @JsonProperty
    String shortDescription;
    @JsonProperty
    String siteGroupUrl;
    @JsonProperty
    String smallLogoUrl;
    @JsonProperty
    String websiteUrl;

    @JsonCreator
    GroupMixin(@JsonProperty(value="id") Integer id, @JsonProperty(value="name") String name) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GroupCountDeserializer
    extends JsonDeserializer<List<Group.GroupCount>> {
        private GroupCountDeserializer() {
        }

        public List<Group.GroupCount> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken() && (dataNode = jp.readValueAsTree().get("values")) != null) {
                return (List)mapper.readValue(dataNode, (TypeReference)new TypeReference<List<Group.GroupCount>>(){});
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GroupCategoryDeserializer
    extends JsonDeserializer<Group.GroupCategory> {
        private GroupCategoryDeserializer() {
        }

        public Group.GroupCategory deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = jp.readValueAsTree();
            return Group.GroupCategory.valueOf(node.get("code").getTextValue().replace('-', '_').toUpperCase());
        }
    }
}

