/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.springframework.social.linkedin.api.Group;
import org.springframework.social.linkedin.api.GroupSettings;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class GroupSettingsMixin {
    @JsonCreator
    GroupSettingsMixin(@JsonProperty(value="allowMessagesFromMembers") Boolean allowMessagesFromMembers, @JsonProperty(value="emailAnnouncementsFromManagers") Boolean emailAnnouncementsFromManagers, @JsonProperty(value="emailDigestFrequency") @JsonDeserialize(using=EmailDigestFrequencyDeserializer.class) GroupSettings.EmailDigestFrequency emailDigestFrequency, @JsonProperty(value="emailForEveryNewPost") Boolean emailForEveryNewPost, @JsonProperty(value="group") Group group, @JsonProperty(value="membershipState") @JsonDeserialize(using=MembershipStateDeserializer.class) Group.MembershipState membershipState, @JsonProperty(value="showGroupLogoInProfile") Boolean showGroupLogoInProfile) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MembershipStateDeserializer
    extends JsonDeserializer<Group.MembershipState> {
        private MembershipStateDeserializer() {
        }

        public Group.MembershipState deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = jp.readValueAsTree();
            return Group.MembershipState.valueOf(node.get("code").getTextValue().replace('-', '_').toUpperCase());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmailDigestFrequencyDeserializer
    extends JsonDeserializer<GroupSettings.EmailDigestFrequency> {
        private EmailDigestFrequencyDeserializer() {
        }

        public GroupSettings.EmailDigestFrequency deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = jp.readValueAsTree();
            return GroupSettings.EmailDigestFrequency.valueOf(node.get("code").getTextValue().replace('-', '_').toUpperCase());
        }
    }
}

