/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.social.linkedin.api.LinkedInProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LikesListDeserializer
extends JsonDeserializer<List<LinkedInProfile>> {
    LikesListDeserializer() {
    }

    public List<LinkedInProfile> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDeserializationConfig(ctxt.getConfig());
        jp.setCodec((ObjectCodec)mapper);
        if (jp.hasCurrentToken()) {
            JsonNode dataNode = jp.readValueAsTree().get("values");
            ArrayList<LinkedInProfile> likes = new ArrayList<LinkedInProfile>();
            for (JsonNode like : dataNode) {
                LinkedInProfile profile = (LinkedInProfile)mapper.readValue(like.get("person"), (TypeReference)new TypeReference<LinkedInProfile>(){});
                likes.add(profile);
            }
            return likes;
        }
        return null;
    }
}

