/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.social.linkedin.api.ConnectionAuthorization;
import org.springframework.social.linkedin.api.CurrentShare;
import org.springframework.social.linkedin.api.Education;
import org.springframework.social.linkedin.api.ImAccount;
import org.springframework.social.linkedin.api.LinkedInDate;
import org.springframework.social.linkedin.api.Location;
import org.springframework.social.linkedin.api.PhoneNumber;
import org.springframework.social.linkedin.api.Position;
import org.springframework.social.linkedin.api.Recommendation;
import org.springframework.social.linkedin.api.Relation;
import org.springframework.social.linkedin.api.TwitterAccount;
import org.springframework.social.linkedin.api.UrlResource;
import org.springframework.social.linkedin.api.impl.json.ConnectionAuthorizationDeserializer;
import org.springframework.social.linkedin.api.impl.json.RecommendationsListDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class LinkedInProfileFullMixin {
    @JsonProperty
    @JsonDeserialize(using=PositionListDeserializer.class)
    List<Position> positions;
    @JsonProperty
    @JsonDeserialize(using=PositionListDeserializer.class)
    List<Position> threeCurrentPositions;
    @JsonProperty
    @JsonDeserialize(using=PositionListDeserializer.class)
    List<Position> threePastPositions;
    @JsonProperty
    @JsonDeserialize(using=RecommendationsListDeserializer.class)
    List<Recommendation> recommendationsReceived;
    @JsonProperty
    @JsonDeserialize(using=ImAccountListDeserializer.class)
    List<ImAccount> imAccounts;
    @JsonProperty
    @JsonDeserialize(using=TwitterAccountListDeserializer.class)
    List<TwitterAccount> twitterAccounts;
    @JsonProperty
    @JsonDeserialize(using=UrlResourceListDeserializer.class)
    List<UrlResource> memberUrlResources;
    @JsonProperty
    @JsonDeserialize(using=PhoneNumberListDeserializer.class)
    List<PhoneNumber> phoneNumbers;
    @JsonProperty
    @JsonDeserialize(using=SkillListDeserializer.class)
    List<String> skills;
    @JsonProperty
    @JsonDeserialize(using=EducationListDeserializer.class)
    List<Education> educations;
    @JsonProperty(value="summary")
    String summary;
    @JsonProperty
    String proposalComments;
    @JsonProperty
    String specialties;
    @JsonProperty
    int numConnections;
    @JsonProperty
    boolean numConnectionsCapped;
    @JsonProperty
    int numRecommenders;
    @JsonProperty
    String mainAddress;
    @JsonProperty
    String associations;
    @JsonProperty
    Location location;
    @JsonProperty
    String interests;
    @JsonProperty
    String honors;
    @JsonProperty
    int distance;
    @JsonProperty
    LinkedInDate dateOfBirth;
    @JsonProperty
    CurrentShare currentShare;
    @JsonProperty
    Relation relationToViewer;
    @JsonProperty(value="apiStandardProfileRequest")
    @JsonDeserialize(using=ConnectionAuthorizationDeserializer.class)
    ConnectionAuthorization connectionAuthorization;

    @JsonCreator
    LinkedInProfileFullMixin(@JsonProperty(value="id") String id, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="headline") String headline, @JsonProperty(value="industry") String industry, @JsonProperty(value="publicProfileUrl") String publicProfileUrl, @JsonProperty(value="siteStandardProfileRequest") UrlResource siteStandardProfileRequest, @JsonProperty(value="pictureUrl") String profilePictureUrl) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SkillListDeserializer
    extends JsonDeserializer<List<String>> {
        private SkillListDeserializer() {
        }

        public List<String> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            ArrayList<String> skills = new ArrayList<String>();
            if (jp.hasCurrentToken() && (dataNode = jp.readValueAsTree().get("values")) != null) {
                for (JsonNode d : dataNode) {
                    String s = d.path("skill").path("name").getTextValue();
                    if (s == null) continue;
                    skills.add(s);
                }
            }
            return skills;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EducationListDeserializer
    extends JsonDeserializer<List<Education>> {
        private EducationListDeserializer() {
        }

        public List<Education> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken() && (dataNode = jp.readValueAsTree().get("values")) != null) {
                return (List)mapper.readValue(dataNode, (TypeReference)new TypeReference<List<Education>>(){});
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PhoneNumberListDeserializer
    extends JsonDeserializer<List<PhoneNumber>> {
        private PhoneNumberListDeserializer() {
        }

        public List<PhoneNumber> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken() && (dataNode = jp.readValueAsTree().get("values")) != null) {
                return (List)mapper.readValue(dataNode, (TypeReference)new TypeReference<List<PhoneNumber>>(){});
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UrlResourceListDeserializer
    extends JsonDeserializer<List<UrlResource>> {
        private UrlResourceListDeserializer() {
        }

        public List<UrlResource> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken() && (dataNode = jp.readValueAsTree().get("values")) != null) {
                return (List)mapper.readValue(dataNode, (TypeReference)new TypeReference<List<UrlResource>>(){});
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TwitterAccountListDeserializer
    extends JsonDeserializer<List<TwitterAccount>> {
        private TwitterAccountListDeserializer() {
        }

        public List<TwitterAccount> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken() && (dataNode = jp.readValueAsTree().get("values")) != null) {
                return (List)mapper.readValue(dataNode, (TypeReference)new TypeReference<List<TwitterAccount>>(){});
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImAccountListDeserializer
    extends JsonDeserializer<List<ImAccount>> {
        private ImAccountListDeserializer() {
        }

        public List<ImAccount> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken() && (dataNode = jp.readValueAsTree().get("values")) != null) {
                return (List)mapper.readValue(dataNode, (TypeReference)new TypeReference<List<ImAccount>>(){});
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PositionListDeserializer
    extends JsonDeserializer<List<Position>> {
        private PositionListDeserializer() {
        }

        public List<Position> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken() && (dataNode = jp.readValueAsTree().get("values")) != null) {
                return (List)mapper.readValue(dataNode, (TypeReference)new TypeReference<List<Position>>(){});
            }
            return null;
        }
    }
}

