/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl;

import java.net.URI;
import java.util.List;
import org.springframework.social.linkedin.api.ConnectionOperations;
import org.springframework.social.linkedin.api.LinkedInConnections;
import org.springframework.social.linkedin.api.LinkedInProfile;
import org.springframework.social.linkedin.api.NetworkStatistics;
import org.springframework.social.support.URIBuilder;
import org.springframework.web.client.RestOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConnectionTemplate
implements ConnectionOperations {
    private final RestOperations restOperations;
    static final String CONNECTIONS_URL = "https://api.linkedin.com/v1/people/~/connections?format=json";
    static final String STATISTICS_URL = "https://api.linkedin.com/v1/people/~/network/network-stats?format=json";

    public ConnectionTemplate(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    @Override
    public List<LinkedInProfile> getConnections() {
        LinkedInConnections connections = (LinkedInConnections)this.restOperations.getForObject(URIBuilder.fromUri((String)CONNECTIONS_URL).build(), LinkedInConnections.class);
        return connections.getConnections();
    }

    @Override
    public List<LinkedInProfile> getConnections(int start, int count) {
        URI uri = URIBuilder.fromUri((String)CONNECTIONS_URL).queryParam("start", String.valueOf(start)).queryParam("count", String.valueOf(count)).build();
        LinkedInConnections connections = (LinkedInConnections)this.restOperations.getForObject(uri, LinkedInConnections.class);
        return connections.getConnections();
    }

    @Override
    public NetworkStatistics getNetworkStatistics() {
        return (NetworkStatistics)this.restOperations.getForObject(STATISTICS_URL, NetworkStatistics.class, new Object[0]);
    }
}

