/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.springframework.social.linkedin.api.impl.json.LinkedInModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeserializationUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    DeserializationUtils() {
    }

    public static <T> T deserializeFromDataNode(JsonParser jp, DeserializationContext ctxt, String propertyName, TypeReference<T> typeReference) throws IOException, JsonProcessingException {
        if (jp.hasCurrentToken() && jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT)) {
            JsonNode dataNode = (JsonNode)jp.readValueAs(JsonNode.class);
            if (dataNode.has(propertyName)) {
                return (T)OBJECT_MAPPER.reader(typeReference).readValue(dataNode.get(propertyName));
            }
            return null;
        }
        throw ctxt.mappingException("Expected JSON object");
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new LinkedInModule());
    }
}

