/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.springframework.social.linkedin.api.Company;
import org.springframework.social.linkedin.api.CompanyJobUpdate;
import org.springframework.social.linkedin.api.Share;
import org.springframework.social.linkedin.api.UrlResource;
import org.springframework.social.linkedin.api.impl.json.LinkedInModule;
import org.springframework.social.linkedin.api.impl.json.LinkedInObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class UpdateContentCompanyMixin
extends LinkedInObjectMixin {
    @JsonProperty(value="company")
    Company company;
    @JsonProperty(value="companyStatusUpdate")
    @JsonDeserialize(using=CompanyStatusUpdateDeserializer.class)
    Share companyStatusUpdate;
    @JsonProperty(value="companyJobUpdate")
    CompanyJobUpdate companyJobUpdate;

    @JsonCreator
    UpdateContentCompanyMixin(@JsonProperty(value="id") String id, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="headline") String headline, @JsonProperty(value="industry") String industry, @JsonProperty(value="publicProfileUrl") String publicProfileUrl, @JsonProperty(value="siteStandardProfileRequest") UrlResource siteStandardProfileRequest, @JsonProperty(value="pictureUrl") String profilePictureUrl) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompanyStatusUpdateDeserializer
    extends JsonDeserializer<Share> {
        private CompanyStatusUpdateDeserializer() {
        }

        public Share deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new LinkedInModule());
            jp.setCodec((ObjectCodec)mapper);
            JsonNode node = (JsonNode)jp.readValueAs(JsonNode.class);
            return (Share)mapper.reader((TypeReference)new TypeReference<Share>(){}).readValue(node.get("share"));
        }
    }
}

