/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.List;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.social.ApiException;
import org.springframework.social.linkedin.api.LinkedInProfile;
import org.springframework.social.linkedin.api.LinkedInProfileFull;
import org.springframework.social.linkedin.api.LinkedInProfiles;
import org.springframework.social.linkedin.api.ProfileField;
import org.springframework.social.linkedin.api.ProfileOperations;
import org.springframework.social.linkedin.api.SearchParameters;
import org.springframework.social.linkedin.api.impl.AbstractTemplate;
import org.springframework.social.support.URIBuilder;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProfileTemplate
extends AbstractTemplate
implements ProfileOperations {
    private RestOperations restOperations;
    private ObjectMapper objectMapper;
    static final String PROFILE_FIELDS = ":(id,first-name,last-name,emailAddress,headline,industry,site-standard-profile-request,public-profile-url,picture-url,summary)?format=json";
    static final String FULL_PROFILE_FIELDS;
    static final String PEOPLE_SEARCH_URL = "https://api.linkedin.com/v1/people-search:(people:(id,first-name,last-name,headline,industry,site-standard-profile-request,public-profile-url,picture-url,summary,api-standard-profile-request))";

    public ProfileTemplate(RestOperations restOperations, ObjectMapper objectMapper) {
        this.restOperations = restOperations;
        this.objectMapper = objectMapper;
    }

    @Override
    public String getProfileId() {
        return this.getUserProfile().getId();
    }

    @Override
    public String getProfileUrl() {
        return this.getUserProfile().getPublicProfileUrl();
    }

    @Override
    public LinkedInProfile getUserProfile() {
        return this.getUserProfile(PROFILE_FIELDS, LinkedInProfile.class);
    }

    @Override
    public LinkedInProfileFull getUserProfileFull() {
        return this.getUserProfile(FULL_PROFILE_FIELDS, LinkedInProfileFull.class);
    }

    @Override
    public LinkedInProfile getProfileById(String id) {
        return this.getProfileFullById(id, PROFILE_FIELDS, LinkedInProfile.class);
    }

    @Override
    public LinkedInProfile getProfileByPublicUrl(String url) {
        return this.getProfileByPublicUrl(url, PROFILE_FIELDS, LinkedInProfile.class);
    }

    @Override
    public LinkedInProfileFull getProfileFullById(String id) {
        return this.getProfileFullById(id, FULL_PROFILE_FIELDS, LinkedInProfileFull.class);
    }

    @Override
    public LinkedInProfileFull getProfileFullByPublicUrl(String url) {
        return this.getProfileByPublicUrl(url, FULL_PROFILE_FIELDS, LinkedInProfileFull.class);
    }

    @Override
    public LinkedInProfiles search(SearchParameters parameters) {
        JsonNode node = (JsonNode)this.restOperations.getForObject(this.expand(PEOPLE_SEARCH_URL, parameters), JsonNode.class);
        try {
            return (LinkedInProfiles)this.objectMapper.reader(LinkedInProfiles.class).readValue(node.path("people"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T getUserProfile(String fields, Class<T> type) {
        return (T)this.restOperations.getForObject(URIBuilder.fromUri((String)("https://api.linkedin.com/v1/people/~" + fields)).build(), type);
    }

    private <T> T getProfileFullById(String id, String fields, Class<T> type) {
        return (T)this.restOperations.getForObject(URIBuilder.fromUri((String)("https://api.linkedin.com/v1/people/id=" + id + fields)).build(), type);
    }

    private <T> T getProfileByPublicUrl(String url, String fields, Class<T> type) {
        try {
            URI uri = URIBuilder.fromUri((String)("https://api.linkedin.com/v1/people/url=" + URLEncoder.encode(url, "UTF-8") + fields)).build();
            return (T)this.restOperations.exchange(uri, HttpMethod.GET, new HttpEntity((Object)""), type).getBody();
        }
        catch (UnsupportedEncodingException unlikely) {
            unlikely.printStackTrace();
            throw new ApiException("linkedin", "Unlikely unsupported encoding error", (Throwable)unlikely);
        }
    }

    private URI expand(String url, SearchParameters parameters) {
        URIBuilder uriBuilder = URIBuilder.fromUri((String)url);
        if (parameters.getKeywords() != null) {
            uriBuilder.queryParam("keywords", parameters.getKeywords());
        }
        if (parameters.getFirstName() != null) {
            uriBuilder.queryParam("first-name", parameters.getFirstName());
        }
        if (parameters.getLastName() != null) {
            uriBuilder.queryParam("last-name", parameters.getLastName());
        }
        if (parameters.getCompanyName() != null) {
            uriBuilder.queryParam("company-name", parameters.getCompanyName());
        }
        if (parameters.getCurrentCompany() != null) {
            uriBuilder.queryParam("current-company", parameters.getCurrentCompany().toString());
        }
        if (parameters.getTitle() != null) {
            uriBuilder.queryParam("title", parameters.getTitle());
        }
        if (parameters.getCurrentTitle() != null) {
            uriBuilder.queryParam("current-title", parameters.getCurrentTitle().toString());
        }
        if (parameters.getSchoolName() != null) {
            uriBuilder.queryParam("school-name", parameters.getSchoolName());
        }
        if (parameters.getCurrentSchool() != null) {
            uriBuilder.queryParam("current-school", parameters.getCurrentSchool().toString());
        }
        if (parameters.getCountryCode() != null) {
            uriBuilder.queryParam("country-code", parameters.getCountryCode());
        }
        if (parameters.getPostalCode() != null) {
            uriBuilder.queryParam("postal-code", parameters.getPostalCode());
        }
        if (parameters.getDistance() != null) {
            uriBuilder.queryParam("distance", parameters.getDistance().toString());
        }
        uriBuilder.queryParam("start", String.valueOf(parameters.getStart()));
        uriBuilder.queryParam("count", String.valueOf(parameters.getCount()));
        if (parameters.getSort() != null) {
            uriBuilder.queryParam("sort", parameters.getSort().toString());
        }
        MultiValueMap<SearchParameters.FacetType, String> facets = parameters.getFacets();
        for (SearchParameters.FacetType ft : facets.keySet()) {
            StringBuilder facetString = new StringBuilder(ft.toString());
            for (String value : (List)facets.get((Object)ft)) {
                facetString.append(",");
                facetString.append(value);
            }
            uriBuilder.queryParam("facet", facetString.toString());
        }
        return uriBuilder.build();
    }

    static {
        StringBuffer b = new StringBuffer();
        b.append(":(");
        boolean first = true;
        block3: for (ProfileField f : ProfileField.values()) {
            switch (f) {
                case CONNECTIONS: {
                    continue block3;
                }
                default: {
                    if (first) {
                        first = false;
                    } else {
                        b.append(',');
                    }
                    b.append((Object)f);
                }
            }
        }
        b.append(")?format=json");
        FULL_PROFILE_FIELDS = b.toString();
    }
}

