/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.security.provider;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.OAuth2Parameters;
import org.springframework.social.security.SocialAuthenticationRedirectException;
import org.springframework.social.security.SocialAuthenticationToken;
import org.springframework.social.security.provider.AbstractSocialAuthenticationService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth2AuthenticationService<S>
extends AbstractSocialAuthenticationService<S> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private OAuth2ConnectionFactory<S> connectionFactory;
    private Set<String> returnToUrlParameters;
    private String defaultScope = "";

    public OAuth2AuthenticationService(OAuth2ConnectionFactory<S> connectionFactory) {
        this.setConnectionFactory(connectionFactory);
    }

    @Override
    public OAuth2ConnectionFactory<S> getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(OAuth2ConnectionFactory<S> connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setReturnToUrlParameters(Set<String> returnToUrlParameters) {
        Assert.notNull(returnToUrlParameters, (String)"returnToUrlParameters cannot be null");
        this.returnToUrlParameters = returnToUrlParameters;
    }

    public Set<String> getReturnToUrlParameters() {
        if (this.returnToUrlParameters == null) {
            this.returnToUrlParameters = new HashSet<String>();
        }
        return this.returnToUrlParameters;
    }

    public void setDefaultScope(String defaultScope) {
        this.defaultScope = defaultScope;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull(this.getConnectionFactory(), (String)"connectionFactory");
    }

    @Override
    public SocialAuthenticationToken getAuthToken(HttpServletRequest request, HttpServletResponse response) throws SocialAuthenticationRedirectException {
        String code = request.getParameter("code");
        if (!StringUtils.hasText((String)code)) {
            OAuth2Parameters params = new OAuth2Parameters();
            params.setRedirectUri(this.buildReturnToUrl(request));
            this.setScope(request, params);
            params.add("state", this.connectionFactory.generateState());
            throw new SocialAuthenticationRedirectException(this.getConnectionFactory().getOAuthOperations().buildAuthenticateUrl(params));
        }
        if (StringUtils.hasText((String)code)) {
            try {
                String returnToUrl = this.buildReturnToUrl(request);
                AccessGrant accessGrant = this.getConnectionFactory().getOAuthOperations().exchangeForAccess(code, returnToUrl, null);
                Connection connection = this.getConnectionFactory().createConnection(accessGrant);
                return new SocialAuthenticationToken(connection, null);
            }
            catch (RestClientException e) {
                this.logger.debug((Object)"failed to exchange for access", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    protected String buildReturnToUrl(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        sb.append("?");
        for (String name : this.getReturnToUrlParameters()) {
            String value = request.getParameter(name);
            if (value == null) continue;
            sb.append(name).append("=").append(value).append("&");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private void setScope(HttpServletRequest request, OAuth2Parameters params) {
        String requestedScope = request.getParameter("scope");
        if (StringUtils.hasLength((String)requestedScope)) {
            params.setScope(requestedScope);
        } else {
            params.setScope(this.defaultScope);
        }
    }
}

