/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.test.client;

import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.social.test.client.MockClientHttpRequest;
import org.springframework.social.test.client.MockClientHttpRequestFactory;
import org.springframework.social.test.client.RequestMatcher;
import org.springframework.social.test.client.ResponseActions;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.support.RestGatewaySupport;

public class MockRestServiceServer {
    private final MockClientHttpRequestFactory mockRequestFactory;

    private MockRestServiceServer(MockClientHttpRequestFactory mockRequestFactory) {
        Assert.notNull((Object)mockRequestFactory, (String)"'mockRequestFactory' must not be null");
        this.mockRequestFactory = mockRequestFactory;
    }

    public static MockRestServiceServer createServer(RestTemplate restTemplate) {
        Assert.notNull((Object)restTemplate, (String)"'restTemplate' must not be null");
        MockClientHttpRequestFactory mockRequestFactory = new MockClientHttpRequestFactory();
        restTemplate.setRequestFactory((ClientHttpRequestFactory)mockRequestFactory);
        return new MockRestServiceServer(mockRequestFactory);
    }

    public static MockRestServiceServer createServer(RestGatewaySupport gatewaySupport) {
        Assert.notNull((Object)gatewaySupport, (String)"'gatewaySupport' must not be null");
        return MockRestServiceServer.createServer(gatewaySupport.getRestTemplate());
    }

    public ResponseActions expect(RequestMatcher requestMatcher) {
        MockClientHttpRequest request = this.mockRequestFactory.expectNewRequest();
        request.addRequestMatcher(requestMatcher);
        return request;
    }

    public void verify() {
        this.mockRequestFactory.verifyRequests();
    }
}

