/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.test.client;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.social.test.client.AssertionErrors;
import org.springframework.social.test.client.MockClientHttpRequest;
import org.springframework.social.test.client.RequestMatcher;
import org.springframework.social.test.client.UriMatcher;
import org.springframework.util.Assert;

public abstract class RequestMatchers {
    private RequestMatchers() {
    }

    public static RequestMatcher anything() {
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError {
            }
        };
    }

    public static RequestMatcher method(final HttpMethod method) {
        Assert.notNull((Object)method, (String)"'method' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError {
                AssertionErrors.assertEquals("Unexpected HttpMethod", method, request.getMethod());
            }
        };
    }

    public static RequestMatcher requestTo(String uri) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        return RequestMatchers.requestTo(URI.create(uri));
    }

    public static RequestMatcher requestTo(URI uri) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        return new UriMatcher(uri);
    }

    public static RequestMatcher header(final String header, final String value) {
        Assert.notNull((Object)header, (String)"'header' must not be null");
        Assert.notNull((Object)value, (String)"'value' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError {
                List actual = request.getHeaders().get((Object)header);
                AssertionErrors.assertTrue("Expected header in request: " + header, actual != null);
                AssertionErrors.assertTrue("Unexpected header", actual.contains(value));
            }
        };
    }

    public static RequestMatcher headerContains(final String header, final String substring) {
        Assert.notNull((Object)header, (String)"'header' must not be null");
        Assert.notNull((Object)substring, (String)"'substring' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError {
                List actualHeaders = request.getHeaders().get((Object)header);
                AssertionErrors.assertTrue("Expected header in request: " + header, actualHeaders != null);
                boolean foundMatch = false;
                for (String headerValue : actualHeaders) {
                    if (!headerValue.contains(substring)) continue;
                    foundMatch = true;
                    break;
                }
                AssertionErrors.assertTrue("Header \"" + header + "\" didn't contain expected text <" + substring + ">", foundMatch);
            }
        };
    }

    public static RequestMatcher body(final String body) {
        Assert.notNull((Object)body, (String)"'body' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError, IOException {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
                AssertionErrors.assertEquals("Unexpected body content", body, mockRequest.getBodyContent());
            }
        };
    }
}

