/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.springframework.social.ResourceNotFoundException;
import org.springframework.social.twitter.api.BlockOperations;
import org.springframework.social.twitter.api.TwitterProfile;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.TwitterProfileList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlockTemplate
extends AbstractTwitterOperations
implements BlockOperations {
    private final RestTemplate restTemplate;

    public BlockTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
    }

    @Override
    public TwitterProfile block(long userId) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"user_id", (Object)String.valueOf(userId));
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("blocks/create.json"), (Object)request, TwitterProfile.class);
    }

    @Override
    public TwitterProfile block(String screenName) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"screen_name", (Object)screenName);
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("blocks/create.json"), (Object)request, TwitterProfile.class);
    }

    @Override
    public TwitterProfile unblock(long userId) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"user_id", (Object)String.valueOf(userId));
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("blocks/destroy.json"), (Object)request, TwitterProfile.class);
    }

    @Override
    public TwitterProfile unblock(String screenName) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"screen_name", (Object)screenName);
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("blocks/destroy.json"), (Object)request, TwitterProfile.class);
    }

    @Override
    public List<TwitterProfile> getBlockedUsers() {
        this.requireAuthorization();
        return (List)this.restTemplate.getForObject(this.buildUri("blocks/blocking.json"), TwitterProfileList.class);
    }

    @Override
    public List<Long> getBlockedUserIds() {
        this.requireAuthorization();
        return (List)this.restTemplate.getForObject(this.buildUri("blocks/blocking/ids.json"), LongList.class);
    }

    @Override
    public boolean isBlocking(long userId) {
        return this.isBlocking(this.buildUri("blocks/exists.json", "user_id", String.valueOf(userId)));
    }

    @Override
    public boolean isBlocking(String screenName) {
        return this.isBlocking(this.buildUri("blocks/exists.json", "screen_name", screenName));
    }

    private boolean isBlocking(URI blockingExistsUri) {
        try {
            this.restTemplate.getForObject(blockingExistsUri, String.class);
            return true;
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongList
    extends ArrayList<Long> {
        private LongList() {
        }
    }
}

