/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.util.ArrayList;
import java.util.List;
import org.springframework.social.twitter.api.StatusDetails;
import org.springframework.social.twitter.api.TimelineOperations;
import org.springframework.social.twitter.api.Tweet;
import org.springframework.social.twitter.api.TwitterProfile;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.TwitterProfileList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimelineTemplate
extends AbstractTwitterOperations
implements TimelineOperations {
    private final RestTemplate restTemplate;

    public TimelineTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
    }

    @Override
    public List<Tweet> getPublicTimeline() {
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/public_timeline.json"), TweetList.class);
    }

    @Override
    public List<Tweet> getHomeTimeline() {
        this.requireAuthorization();
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/home_timeline.json"), TweetList.class);
    }

    @Override
    public List<Tweet> getFriendsTimeline() {
        this.requireAuthorization();
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/friends_timeline.json"), TweetList.class);
    }

    @Override
    public List<Tweet> getUserTimeline() {
        this.requireAuthorization();
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/user_timeline.json"), TweetList.class);
    }

    @Override
    public List<Tweet> getUserTimeline(String screenName) {
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/user_timeline.json", "screen_name", screenName), TweetList.class);
    }

    @Override
    public List<Tweet> getUserTimeline(long userId) {
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/user_timeline.json", "user_id", String.valueOf(userId)), TweetList.class);
    }

    @Override
    public List<Tweet> getMentions() {
        this.requireAuthorization();
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/mentions.json"), TweetList.class);
    }

    @Override
    public List<Tweet> getRetweetedByMe() {
        this.requireAuthorization();
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/retweeted_by_me.json"), TweetList.class);
    }

    @Override
    public List<Tweet> getRetweetedToMe() {
        this.requireAuthorization();
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/retweeted_to_me.json"), TweetList.class);
    }

    @Override
    public List<Tweet> getRetweetsOfMe() {
        this.requireAuthorization();
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/retweets_of_me.json"), TweetList.class);
    }

    @Override
    public Tweet getStatus(long tweetId) {
        return (Tweet)this.restTemplate.getForObject(this.buildUri("statuses/show/" + tweetId + ".json"), Tweet.class);
    }

    @Override
    public void updateStatus(String message) {
        this.updateStatus(message, new StatusDetails());
    }

    @Override
    public void updateStatus(String message, StatusDetails details) {
        this.requireAuthorization();
        LinkedMultiValueMap tweetParams = new LinkedMultiValueMap();
        tweetParams.add((Object)"status", (Object)message);
        tweetParams.putAll(details.toParameterMap());
        this.restTemplate.postForObject(this.buildUri("statuses/update.json"), (Object)tweetParams, String.class);
    }

    @Override
    public void deleteStatus(long tweetId) {
        this.requireAuthorization();
        this.restTemplate.delete(this.buildUri("statuses/destroy/" + tweetId + ".json"));
    }

    @Override
    public void retweet(long tweetId) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        this.restTemplate.postForObject(this.buildUri("statuses/retweet/" + tweetId + ".json"), (Object)data, String.class);
    }

    @Override
    public List<Tweet> getRetweets(long tweetId) {
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/retweets/" + tweetId + ".json"), TweetList.class);
    }

    @Override
    public List<TwitterProfile> getRetweetedBy(long tweetId) {
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/" + tweetId + "/retweeted_by.json"), TwitterProfileList.class);
    }

    @Override
    public List<Long> getRetweetedByIds(long tweetId) {
        this.requireAuthorization();
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/" + tweetId + "/retweeted_by/ids.json"), LongList.class);
    }

    @Override
    public List<Tweet> getFavorites() {
        this.requireAuthorization();
        return (List)this.restTemplate.getForObject(this.buildUri("favorites.json"), TweetList.class);
    }

    @Override
    public void addToFavorites(long tweetId) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        this.restTemplate.postForObject(this.buildUri("favorites/create/" + tweetId + ".json"), (Object)data, String.class);
    }

    @Override
    public void removeFromFavorites(long tweetId) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        this.restTemplate.postForObject(this.buildUri("favorites/destroy/" + tweetId + ".json"), (Object)data, String.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TweetList
    extends ArrayList<Tweet> {
        private TweetList() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongList
    extends ArrayList<Long> {
        private LongList() {
        }
    }
}

