/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.util.Date;
import org.springframework.social.twitter.api.GeoCode;

public class SearchParameters {
    private String query;
    private GeoCode geoCode;
    private String lang;
    private String locale;
    private ResultType resultType;
    private Integer count;
    private Date untilDate;
    private Long sinceId;
    private Long maxId;
    private boolean includeEntities = true;

    public SearchParameters(String query) {
        this.query = query;
    }

    public SearchParameters geoCode(GeoCode geoCode) {
        this.geoCode = geoCode;
        return this;
    }

    public SearchParameters lang(String lang) {
        this.lang = lang;
        return this;
    }

    public SearchParameters locale(String locale) {
        this.locale = locale;
        return this;
    }

    public SearchParameters resultType(ResultType resultType) {
        this.resultType = resultType;
        return this;
    }

    public SearchParameters count(int count) {
        this.count = count;
        return this;
    }

    public SearchParameters until(Date untilDate) {
        this.untilDate = untilDate;
        return this;
    }

    public SearchParameters sinceId(long sinceId) {
        this.sinceId = sinceId;
        return this;
    }

    public SearchParameters maxId(long maxId) {
        this.maxId = maxId;
        return this;
    }

    public SearchParameters includeEntities(boolean includeEntities) {
        this.includeEntities = includeEntities;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    public GeoCode getGeoCode() {
        return this.geoCode;
    }

    public String getLang() {
        return this.lang;
    }

    public String getLocale() {
        return this.locale;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public Integer getCount() {
        return this.count;
    }

    public Date getUntil() {
        return this.untilDate;
    }

    public Long getSinceId() {
        return this.sinceId;
    }

    public Long getMaxId() {
        return this.maxId;
    }

    public boolean isIncludeEntities() {
        return this.includeEntities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchParameters other = (SearchParameters)o;
        return other.query.equals(this.query) && other.count == this.count && this.bothNullOrEquals(other.geoCode, this.geoCode) && other.includeEntities == this.includeEntities && this.bothNullOrEquals(other.lang, this.lang) && this.bothNullOrEquals(other.locale, this.locale) && this.bothNullOrEquals(other.maxId, this.maxId) && this.bothNullOrEquals((Object)other.resultType, (Object)this.resultType) && this.bothNullOrEquals(other.sinceId, this.sinceId) && this.bothNullOrEquals(other.untilDate, this.untilDate);
    }

    private boolean bothNullOrEquals(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o2 != null && o1.equals(o2);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        result = 31 * result + (this.count == null ? 0 : this.count.hashCode());
        result = 31 * result + (this.sinceId == null ? 0 : this.sinceId.hashCode());
        result = 31 * result + (this.maxId == null ? 0 : this.maxId.hashCode());
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        result = 31 * result + (this.geoCode == null ? 0 : this.geoCode.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.resultType == null ? 0 : this.resultType.hashCode());
        result = 31 * result + (this.untilDate == null ? 0 : this.untilDate.hashCode());
        result = 31 * result + (this.includeEntities ? 0 : 1);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResultType {
        MIXED("mixed"),
        RECENT("recent"),
        POPULAR("popular");

        private String resultType;

        private ResultType(String resultType) {
            this.resultType = resultType;
        }

        public String toString() {
            return this.resultType;
        }
    }
}

