/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.social.twitter.api.Entities;
import org.springframework.social.twitter.api.TickerSymbolEntity;
import org.springframework.social.twitter.api.Tweet;
import org.springframework.social.twitter.api.TwitterProfile;
import org.springframework.social.twitter.api.impl.TwitterModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TweetDeserializer
extends JsonDeserializer<Tweet> {
    private static final String TIMELINE_DATE_FORMAT = "EEE MMM dd HH:mm:ss ZZZZZ yyyy";

    TweetDeserializer() {
    }

    public Tweet deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        JsonNode tree = jp.readValueAsTree();
        if (null == tree || tree.isMissingNode() || tree.isNull()) {
            return null;
        }
        Tweet tweet = this.deserialize(tree);
        jp.skipChildren();
        return tweet;
    }

    public Tweet deserialize(JsonNode tree) throws IOException, JsonProcessingException {
        long id = tree.path("id").asLong();
        String text = tree.path("text").asText();
        if (id <= 0L || text == null || text.isEmpty()) {
            return null;
        }
        JsonNode fromUserNode = tree.get("user");
        String dateFormat = TIMELINE_DATE_FORMAT;
        String fromScreenName = fromUserNode.get("screen_name").asText();
        long fromId = fromUserNode.get("id").asLong();
        String fromImageUrl = fromUserNode.get("profile_image_url").asText();
        Date createdAt = this.toDate(tree.get("created_at").asText(), new SimpleDateFormat(dateFormat, Locale.ENGLISH));
        String source = tree.get("source").asText();
        JsonNode toUserIdNode = tree.get("in_reply_to_user_id");
        Long toUserId = toUserIdNode != null ? Long.valueOf(toUserIdNode.getLongValue()) : null;
        JsonNode languageCodeNode = tree.get("iso_language_code");
        String languageCode = languageCodeNode != null ? languageCodeNode.asText() : null;
        Tweet tweet = new Tweet(id, text, createdAt, fromScreenName, fromImageUrl, toUserId, fromId, languageCode, source);
        JsonNode inReplyToStatusIdNode = tree.get("in_reply_to_status_id");
        Long inReplyToStatusId = inReplyToStatusIdNode != null && !inReplyToStatusIdNode.isNull() ? Long.valueOf(inReplyToStatusIdNode.getLongValue()) : null;
        tweet.setInReplyToStatusId(inReplyToStatusId);
        JsonNode inReplyToUserIdNode = tree.get("in_reply_to_user_id");
        Long inReplyUsersId = inReplyToUserIdNode != null && !inReplyToUserIdNode.isNull() ? Long.valueOf(inReplyToUserIdNode.getLongValue()) : null;
        tweet.setInReplyToUserId(inReplyUsersId);
        tweet.setInReplyToScreenName(tree.path("in_reply_to_screen_name").getTextValue());
        JsonNode retweetCountNode = tree.get("retweet_count");
        Integer retweetCount = retweetCountNode != null && !retweetCountNode.isNull() ? Integer.valueOf(retweetCountNode.getIntValue()) : null;
        tweet.setRetweetCount(retweetCount);
        JsonNode retweetedNode = tree.get("retweeted");
        JsonNode retweetedStatusNode = tree.get("retweeted_status");
        boolean retweeted = retweetedNode != null && !retweetedNode.isNull() ? retweetedNode.getBooleanValue() : false;
        tweet.setRetweeted(retweeted);
        Tweet retweetedStatus = retweetedStatusNode != null ? this.deserialize(retweetedStatusNode) : null;
        tweet.setRetweetedStatus(retweetedStatus);
        JsonNode favoritedNode = tree.get("favorited");
        boolean favorited = favoritedNode != null && !favoritedNode.isNull() ? favoritedNode.getBooleanValue() : false;
        tweet.setFavorited(favorited);
        Entities entities = this.toEntities(tree.get("entities"), text);
        tweet.setEntities(entities);
        TwitterProfile user = this.toProfile(fromUserNode);
        tweet.setUser(user);
        return tweet;
    }

    private ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new TwitterModule());
        return mapper;
    }

    private Date toDate(String dateString, DateFormat dateFormat) {
        if (dateString == null) {
            return null;
        }
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private Entities toEntities(JsonNode node, String text) throws IOException {
        if (null == node || node.isNull() || node.isMissingNode()) {
            return null;
        }
        ObjectMapper mapper = this.createMapper();
        Entities entities = (Entities)mapper.readValue(node, Entities.class);
        this.extractTickerSymbolEntitiesFromText(text, entities);
        return entities;
    }

    private void extractTickerSymbolEntitiesFromText(String text, Entities entities) {
        Pattern pattern = Pattern.compile("\\$[A-Za-z]+");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            String tickerSymbol = matchResult.group().substring(1);
            String url = "https://twitter.com/search?q=%24" + tickerSymbol + "&src=ctag";
            entities.getTickerSymbols().add(new TickerSymbolEntity(tickerSymbol, url, new int[]{matchResult.start(), matchResult.end()}));
        }
    }

    private TwitterProfile toProfile(JsonNode node) throws IOException {
        if (null == node || node.isNull() || node.isMissingNode()) {
            return null;
        }
        ObjectMapper mapper = this.createMapper();
        return (TwitterProfile)mapper.readValue(node, TwitterProfile.class);
    }
}

