/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api;

import java.util.Date;

public class RateLimitStatus {
    private final String endpoint;
    private final int quarterOfHourLimit;
    private final int remainingHits;
    private final long resetTimeInSeconds;
    private final Date resetTime;

    public RateLimitStatus(String endpoint, int quarterOfHourLimit, int remainingHits, long resetTimeInSeconds) {
        this.endpoint = endpoint;
        this.quarterOfHourLimit = quarterOfHourLimit;
        this.remainingHits = remainingHits;
        this.resetTimeInSeconds = resetTimeInSeconds;
        this.resetTime = new Date(resetTimeInSeconds * 1000L);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public int getQuarterOfHourLimit() {
        return this.quarterOfHourLimit;
    }

    public int getRemainingHits() {
        return this.remainingHits;
    }

    public long getResetTimeInSeconds() {
        return this.resetTimeInSeconds;
    }

    public Date getResetTime() {
        return this.resetTime;
    }

    public int getSecondsUntilReset() {
        return (int)(this.resetTimeInSeconds - System.currentTimeMillis() / 1000L);
    }
}

