/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.twitter.api.FilterStreamParameters;
import org.springframework.social.twitter.api.Stream;
import org.springframework.social.twitter.api.StreamListener;
import org.springframework.social.twitter.api.StreamingOperations;
import org.springframework.social.twitter.api.UserStreamParameters;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.StreamCreationException;
import org.springframework.social.twitter.api.impl.StreamReader;
import org.springframework.social.twitter.api.impl.StreamReaderImpl;
import org.springframework.social.twitter.api.impl.ThreadedStreamConsumer;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StreamingTemplate
extends AbstractTwitterOperations
implements StreamingOperations {
    private final RestTemplate restTemplate;
    private static final String SAMPLE_STREAM_URL = "https://stream.twitter.com/1.1/statuses/sample.json";
    private static final String FIREHOSE_STREAM_URL = "https://stream.twitter.com/1.1/statuses/firehose.json";
    private static final String FILTERED_STREAM_URL = "https://stream.twitter.com/1.1/statuses/filter.json";
    private static final String USER_STREAM_URL = "https://userstream.twitter.com/1.1/user.json";
    private static final LinkedMultiValueMap<String, String> EMPTY_BODY = new LinkedMultiValueMap();

    public StreamingTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser, boolean isAuthorizedForApp) {
        super(isAuthorizedForUser, isAuthorizedForApp);
        this.restTemplate = restTemplate;
    }

    @Override
    public Stream firehose(final List<StreamListener> listeners) {
        Assert.notEmpty(listeners, (String)"Listeners collection may not be null or empty");
        ThreadedStreamConsumer stream = new ThreadedStreamConsumer(){

            protected StreamReader getStreamReader() throws StreamCreationException {
                return StreamingTemplate.this.createStream(HttpMethod.GET, StreamingTemplate.FIREHOSE_STREAM_URL, (MultiValueMap<String, String>)((MultiValueMap)EMPTY_BODY), listeners);
            }
        };
        stream.open();
        return stream;
    }

    @Override
    public Stream firehose(final int backfill, final List<StreamListener> listeners) {
        Assert.isTrue((Math.abs(backfill) >= -1 && Math.abs(backfill) <= 150000 ? 1 : 0) != 0, (String)"'backfill' must be a value between 1 to 150000 or -1 to -150000");
        Assert.notEmpty(listeners, (String)"Listeners collection may not be null or empty");
        ThreadedStreamConsumer stream = new ThreadedStreamConsumer(){

            protected StreamReader getStreamReader() throws StreamCreationException {
                LinkedMultiValueMap parameters = new LinkedMultiValueMap(1);
                parameters.set((Object)"count", (Object)String.valueOf(backfill));
                return StreamingTemplate.this.createStream(HttpMethod.GET, StreamingTemplate.FIREHOSE_STREAM_URL, (MultiValueMap<String, String>)((MultiValueMap)parameters), listeners);
            }
        };
        stream.open();
        return stream;
    }

    @Override
    public Stream sample(final List<StreamListener> listeners) {
        Assert.notEmpty(listeners, (String)"Listeners collection may not be null or empty");
        ThreadedStreamConsumer stream = new ThreadedStreamConsumer(){

            protected StreamReader getStreamReader() throws StreamCreationException {
                return StreamingTemplate.this.createStream(HttpMethod.GET, StreamingTemplate.SAMPLE_STREAM_URL, (MultiValueMap<String, String>)((MultiValueMap)EMPTY_BODY), listeners);
            }
        };
        stream.open();
        return stream;
    }

    @Override
    public Stream filter(String trackKeywords, List<StreamListener> listeners) {
        return this.filter((FilterStreamParameters)new FilterStreamParameters().track(trackKeywords), listeners);
    }

    @Override
    public Stream filter(final FilterStreamParameters parameters, final List<StreamListener> listeners) {
        Assert.notNull((Object)parameters, (String)"StreamFilter may not be null");
        Assert.isTrue((boolean)parameters.isValid(), (String)"At least one of follow, track, or location must be specified in StreamFilter");
        Assert.notEmpty(listeners, (String)"Listeners collection may not be null or empty");
        ThreadedStreamConsumer stream = new ThreadedStreamConsumer(){

            protected StreamReader getStreamReader() throws StreamCreationException {
                return StreamingTemplate.this.createStream(HttpMethod.POST, StreamingTemplate.FILTERED_STREAM_URL, (MultiValueMap<String, String>)parameters.toParameterMap(), listeners);
            }
        };
        stream.open();
        return stream;
    }

    @Override
    public Stream user(List<StreamListener> listeners) {
        return this.user(new UserStreamParameters(), listeners);
    }

    @Override
    public Stream user(final UserStreamParameters parameters, final List<StreamListener> listeners) {
        Assert.notNull((Object)parameters, (String)"StreamFilter may not be null");
        Assert.notEmpty(listeners, (String)"Listeners collection may not be null or empty");
        ThreadedStreamConsumer stream = new ThreadedStreamConsumer(){

            protected StreamReader getStreamReader() throws StreamCreationException {
                return StreamingTemplate.this.createStream(HttpMethod.POST, StreamingTemplate.USER_STREAM_URL, (MultiValueMap<String, String>)parameters.toParameterMap(), listeners);
            }
        };
        stream.open();
        return stream;
    }

    private StreamReader createStream(HttpMethod method, String streamUrl, MultiValueMap<String, String> body, List<StreamListener> listeners) throws StreamCreationException {
        try {
            ClientHttpResponse response = this.executeRequest(method, streamUrl, body);
            if (response.getStatusCode().value() > 200) {
                throw new StreamCreationException("Unable to create stream", response.getStatusCode());
            }
            return new StreamReaderImpl(response.getBody(), listeners);
        }
        catch (IOException e) {
            throw new StreamCreationException("Unable to create stream.", e);
        }
    }

    private ClientHttpResponse executeRequest(HttpMethod method, String url, MultiValueMap<String, String> body) throws IOException {
        ClientHttpRequestFactory requestFactory = this.restTemplate.getRequestFactory();
        ClientHttpRequest request = requestFactory.createRequest(URI.create(url), method);
        OutputStreamWriter writer = new OutputStreamWriter(request.getBody());
        writer.write(this.createFormUrlEncodedBodyString(body));
        writer.flush();
        request.getHeaders().setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        return request.execute();
    }

    private String createFormUrlEncodedBodyString(MultiValueMap<String, String> body) {
        StringBuffer bodyBuffer = new StringBuffer();
        Iterator bodyIt = body.entrySet().iterator();
        while (bodyIt.hasNext()) {
            Map.Entry entry = (Map.Entry)bodyIt.next();
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            Iterator valuesIt = values.iterator();
            while (valuesIt.hasNext()) {
                bodyBuffer.append(key).append("=").append(this.formEncode((String)valuesIt.next()));
                if (!valuesIt.hasNext()) continue;
                bodyBuffer.append("&");
            }
            if (!bodyIt.hasNext()) continue;
            bodyBuffer.append("&");
        }
        return bodyBuffer.toString();
    }

    private String formEncode(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException wontHappen) {
            throw new IllegalStateException(wontHappen);
        }
    }
}

