/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.UserProfile;
import org.springframework.web.servlet.view.AbstractView;

public class GenericConnectionStatusView
extends AbstractView {
    private final String providerId;
    private final String providerDisplayName;

    public GenericConnectionStatusView(String providerId, String providerDisplayName) {
        this.providerId = providerId;
        this.providerDisplayName = providerDisplayName;
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setHeader("Content-Type", "text/html");
        response.getWriter().write(this.generateConnectionViewHtml(this.getProfileIfConnected(model)));
    }

    private String generateConnectionViewHtml(UserProfile profile) {
        StringBuilder builder = new StringBuilder();
        if (profile == null) {
            builder.append("<h3>Connect to " + this.providerDisplayName + "</h3>");
            builder.append("<form action=\"/connect/");
            builder.append(this.providerId);
            builder.append("\" method=\"POST\">");
            builder.append("<div class=\"formInfo\">");
            builder.append("<p>You aren't connected to ");
            builder.append(this.providerDisplayName);
            builder.append(" yet. Click the button to connect with your ");
            builder.append(this.providerDisplayName);
            builder.append(" account.</p>");
            builder.append("</div>");
            builder.append("<p><button type=\"submit\">Connect to ");
            builder.append(this.providerDisplayName);
            builder.append("</button></p>");
            builder.append("</form>");
        } else {
            builder.append("<h3>Connected to ");
            builder.append(this.providerDisplayName);
            builder.append("</h3>");
            builder.append("<p>Hello, ");
            builder.append(profile.getName());
            builder.append("!</p><p>You are now connected to ");
            builder.append(this.providerDisplayName);
            String username = profile.getUsername();
            if (username != null) {
                builder.append(" as ");
                builder.append(username);
            }
            builder.append(".</p>");
        }
        return builder.toString();
    }

    private UserProfile getProfileIfConnected(Map<String, Object> model) {
        List connections = (List)model.get("connections");
        if (connections != null) {
            for (Connection connection : connections) {
                if (!connection.getKey().getProviderId().equals(this.providerId)) continue;
                return connection.fetchUserProfile();
            }
        }
        return null;
    }
}

