/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.reflect.PerClauseKind;
import org.springframework.aop.Advisor;
import org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.AspectMetadata;
import org.springframework.aop.aspectj.annotation.BeanFactoryAspectInstanceFactory;
import org.springframework.aop.aspectj.annotation.PrototypeAspectInstanceFactory;
import org.springframework.aop.aspectj.annotation.ReflectiveAspectJAdvisorFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanFactoryAspectJAdvisorsBuilder {
    private static final Log logger = LogFactory.getLog(BeanFactoryAspectJAdvisorsBuilder.class);
    private final ListableBeanFactory beanFactory;
    private final AspectJAdvisorFactory advisorFactory;

    public BeanFactoryAspectJAdvisorsBuilder(ListableBeanFactory beanFactory) {
        this(beanFactory, new ReflectiveAspectJAdvisorFactory());
    }

    public BeanFactoryAspectJAdvisorsBuilder(ListableBeanFactory beanFactory, AspectJAdvisorFactory advisorFactory) {
        Assert.notNull((Object)beanFactory, (String)"ListableBeanFactory must not be null");
        Assert.notNull((Object)advisorFactory, (String)"AspectJAdvisorFactory must not be null");
        this.beanFactory = beanFactory;
        this.advisorFactory = advisorFactory;
    }

    public List<Advisor> buildAspectJAdvisors() {
        String[] beanNames;
        LinkedList<Advisor> advisors = new LinkedList<Advisor>();
        for (String beanName : beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, Object.class, (boolean)true, (boolean)false)) {
            Class beanType;
            if (!this.isEligibleBean(beanName) || (beanType = this.beanFactory.getType(beanName)) == null || !this.advisorFactory.isAspect(beanType)) continue;
            AspectMetadata amd = new AspectMetadata(beanType, beanName);
            BeanFactoryAspectInstanceFactory factory = null;
            if (amd.getAjType().getPerClause().getKind() == PerClauseKind.SINGLETON) {
                factory = new BeanFactoryAspectInstanceFactory((BeanFactory)this.beanFactory, beanName);
            } else {
                if (this.beanFactory.isSingleton(beanName)) {
                    throw new IllegalArgumentException("Bean with name '" + beanName + "' is a singleton, but aspect instantiation model is not singleton");
                }
                factory = new PrototypeAspectInstanceFactory((BeanFactory)this.beanFactory, beanName);
            }
            List<Advisor> classAdvisors = this.advisorFactory.getAdvisors(factory);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + classAdvisors.size() + " AspectJ advice methods in bean with name '" + beanName + "'"));
            }
            advisors.addAll(classAdvisors);
        }
        return advisors;
    }

    protected boolean isEligibleBean(String beanName) {
        return true;
    }
}

