/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.autoproxy;

import java.util.Comparator;
import org.springframework.aop.Advisor;
import org.springframework.aop.aspectj.AspectJAopUtils;
import org.springframework.aop.aspectj.AspectJPrecedenceInformation;
import org.springframework.core.OrderComparator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AspectJPrecedenceComparator
implements Comparator {
    private static final int HIGHER_PRECEDENCE = -1;
    private static final int SAME_PRECEDENCE = 0;
    private static final int LOWER_PRECEDENCE = 1;
    private static final int NOT_COMPARABLE = 0;
    private final Comparator<? super Advisor> advisorComparator;

    public AspectJPrecedenceComparator() {
        this.advisorComparator = OrderComparator.INSTANCE;
    }

    public AspectJPrecedenceComparator(Comparator<? super Advisor> advisorComparator) {
        Assert.notNull(advisorComparator, (String)"Advisor comparator must not be null");
        this.advisorComparator = advisorComparator;
    }

    public int compare(Object o1, Object o2) {
        boolean oneOrOtherIsBeforeAdvice;
        if (!(o1 instanceof Advisor) || !(o2 instanceof Advisor)) {
            throw new IllegalArgumentException("AspectJPrecedenceComparator can only compare the order of Advisors, but was passed [" + o1 + "] and [" + o2 + "]");
        }
        Advisor advisor1 = (Advisor)o1;
        Advisor advisor2 = (Advisor)o2;
        boolean oneOrOtherIsAfterAdvice = AspectJAopUtils.isAfterAdvice(advisor1) || AspectJAopUtils.isAfterAdvice(advisor2);
        boolean bl = oneOrOtherIsBeforeAdvice = AspectJAopUtils.isBeforeAdvice(advisor1) || AspectJAopUtils.isBeforeAdvice(advisor2);
        if (oneOrOtherIsAfterAdvice && oneOrOtherIsBeforeAdvice) {
            return 0;
        }
        int advisorPrecedence = this.advisorComparator.compare(advisor1, advisor2);
        if (advisorPrecedence == 0 && this.declaredInSameAspect(advisor1, advisor2)) {
            advisorPrecedence = this.comparePrecedenceWithinAspect(advisor1, advisor2);
        }
        return advisorPrecedence;
    }

    private int comparePrecedenceWithinAspect(Advisor advisor1, Advisor advisor2) {
        boolean oneOrOtherIsAfterAdvice = AspectJAopUtils.isAfterAdvice(advisor1) || AspectJAopUtils.isAfterAdvice(advisor2);
        int adviceDeclarationOrderDelta = this.getAspectDeclarationOrder(advisor1) - this.getAspectDeclarationOrder(advisor2);
        if (oneOrOtherIsAfterAdvice) {
            if (adviceDeclarationOrderDelta < 0) {
                return 1;
            }
            if (adviceDeclarationOrderDelta == 0) {
                return 0;
            }
            return -1;
        }
        if (adviceDeclarationOrderDelta < 0) {
            return -1;
        }
        if (adviceDeclarationOrderDelta == 0) {
            return 0;
        }
        return 1;
    }

    private boolean declaredInSameAspect(Advisor advisor1, Advisor advisor2) {
        return this.hasAspectName(advisor1) && this.hasAspectName(advisor2) && this.getAspectName(advisor1).equals(this.getAspectName(advisor2));
    }

    private boolean hasAspectName(Advisor anAdvisor) {
        return anAdvisor instanceof AspectJPrecedenceInformation || anAdvisor.getAdvice() instanceof AspectJPrecedenceInformation;
    }

    private String getAspectName(Advisor anAdvisor) {
        return AspectJAopUtils.getAspectJPrecedenceInformationFor(anAdvisor).getAspectName();
    }

    private int getAspectDeclarationOrder(Advisor anAdvisor) {
        AspectJPrecedenceInformation precedenceInfo = AspectJAopUtils.getAspectJPrecedenceInformationFor(anAdvisor);
        if (precedenceInfo != null) {
            return precedenceInfo.getDeclarationOrder();
        }
        return 0;
    }
}

