/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.util.ObjectUtils;

public abstract class MethodOverride
implements BeanMetadataElement {
    private final String methodName;
    private boolean overloaded = true;
    private Object source;

    protected MethodOverride(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    protected void setOverloaded(boolean overloaded) {
        this.overloaded = overloaded;
    }

    protected boolean isOverloaded() {
        return this.overloaded;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    public abstract boolean matches(Method var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodOverride that = (MethodOverride)o;
        if (this.overloaded != that.overloaded) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.methodName, (Object)that.methodName)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.source, (Object)that.source);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.methodName);
        result = ObjectUtils.nullSafeHashCode((Object)this.source);
        result = 29 * result + (this.overloaded ? 1 : 0);
        return result;
    }
}

