/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Provider;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.ConstructorResolver;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.support.SimpleAutowireCandidateResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultListableBeanFactory
extends AbstractAutowireCapableBeanFactory
implements ConfigurableListableBeanFactory,
BeanDefinitionRegistry,
Serializable {
    private static Class<?> javaxInjectProviderClass = null;
    private static final Map<String, Reference<DefaultListableBeanFactory>> serializableFactories;
    private String serializationId;
    private boolean allowBeanDefinitionOverriding = true;
    private boolean allowEagerClassLoading = true;
    private Comparator dependencyComparator;
    private AutowireCandidateResolver autowireCandidateResolver = new SimpleAutowireCandidateResolver();
    private final Map<Class<?>, Object> resolvableDependencies = new HashMap(16);
    private final Map<String, BeanDefinition> beanDefinitionMap = new ConcurrentHashMap<String, BeanDefinition>(64);
    private final Map<Class<?>, String[]> allBeanNamesByType = new ConcurrentHashMap(64);
    private final Map<Class<?>, String[]> singletonBeanNamesByType = new ConcurrentHashMap(64);
    private final List<String> beanDefinitionNames = new ArrayList<String>();
    private boolean configurationFrozen = false;
    private String[] frozenBeanDefinitionNames;

    public DefaultListableBeanFactory() {
    }

    public DefaultListableBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public void setSerializationId(String serializationId) {
        if (serializationId != null) {
            serializableFactories.put(serializationId, new WeakReference<DefaultListableBeanFactory>(this));
        } else if (this.serializationId != null) {
            serializableFactories.remove(this.serializationId);
        }
        this.serializationId = serializationId;
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public void setAllowEagerClassLoading(boolean allowEagerClassLoading) {
        this.allowEagerClassLoading = allowEagerClassLoading;
    }

    public void setDependencyComparator(Comparator dependencyComparator) {
        this.dependencyComparator = dependencyComparator;
    }

    public Comparator getDependencyComparator() {
        return this.dependencyComparator;
    }

    public void setAutowireCandidateResolver(final AutowireCandidateResolver autowireCandidateResolver) {
        Assert.notNull((Object)autowireCandidateResolver, (String)"AutowireCandidateResolver must not be null");
        if (autowireCandidateResolver instanceof BeanFactoryAware) {
            if (System.getSecurityManager() != null) {
                final DefaultListableBeanFactory target = this;
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        ((BeanFactoryAware)((Object)autowireCandidateResolver)).setBeanFactory(target);
                        return null;
                    }
                }, this.getAccessControlContext());
            } else {
                ((BeanFactoryAware)((Object)autowireCandidateResolver)).setBeanFactory(this);
            }
        }
        this.autowireCandidateResolver = autowireCandidateResolver;
    }

    public AutowireCandidateResolver getAutowireCandidateResolver() {
        return this.autowireCandidateResolver;
    }

    @Override
    public void copyConfigurationFrom(ConfigurableBeanFactory otherFactory) {
        super.copyConfigurationFrom(otherFactory);
        if (otherFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory otherListableFactory = (DefaultListableBeanFactory)otherFactory;
            this.allowBeanDefinitionOverriding = otherListableFactory.allowBeanDefinitionOverriding;
            this.allowEagerClassLoading = otherListableFactory.allowEagerClassLoading;
            this.autowireCandidateResolver = otherListableFactory.autowireCandidateResolver;
            this.resolvableDependencies.putAll(otherListableFactory.resolvableDependencies);
        }
    }

    @Override
    public <T> T getBean(Class<T> requiredType) throws BeansException {
        Assert.notNull(requiredType, (String)"Required type must not be null");
        String[] beanNames = this.getBeanNamesForType(requiredType);
        if (beanNames.length > 1) {
            ArrayList<String> autowireCandidates = new ArrayList<String>();
            for (String beanName : beanNames) {
                if (!this.getBeanDefinition(beanName).isAutowireCandidate()) continue;
                autowireCandidates.add(beanName);
            }
            if (autowireCandidates.size() > 0) {
                beanNames = autowireCandidates.toArray(new String[autowireCandidates.size()]);
            }
        }
        if (beanNames.length == 1) {
            return this.getBean(beanNames[0], requiredType);
        }
        if (beanNames.length > 1) {
            T primaryBean = null;
            for (String beanName : beanNames) {
                T beanInstance = this.getBean(beanName, requiredType);
                if (!this.isPrimary(beanName, beanInstance)) continue;
                if (primaryBean != null) {
                    throw new NoUniqueBeanDefinitionException(requiredType, beanNames.length, "more than one 'primary' bean found of required type: " + Arrays.asList(beanNames));
                }
                primaryBean = beanInstance;
            }
            if (primaryBean != null) {
                return primaryBean;
            }
            throw new NoUniqueBeanDefinitionException(requiredType, beanNames);
        }
        if (this.getParentBeanFactory() != null) {
            return this.getParentBeanFactory().getBean(requiredType);
        }
        throw new NoSuchBeanDefinitionException(requiredType);
    }

    @Override
    public boolean containsBeanDefinition(String beanName) {
        Assert.notNull((Object)beanName, (String)"Bean name must not be null");
        return this.beanDefinitionMap.containsKey(beanName);
    }

    @Override
    public int getBeanDefinitionCount() {
        return this.beanDefinitionMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getBeanDefinitionNames() {
        Map<String, BeanDefinition> map = this.beanDefinitionMap;
        synchronized (map) {
            if (this.frozenBeanDefinitionNames != null) {
                return this.frozenBeanDefinitionNames;
            }
            return StringUtils.toStringArray(this.beanDefinitionNames);
        }
    }

    @Override
    public String[] getBeanNamesForType(Class<?> type) {
        return this.getBeanNamesForType(type, true, true);
    }

    @Override
    public String[] getBeanNamesForType(Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        if (!this.isConfigurationFrozen() || type == null || !allowEagerInit) {
            return this.doGetBeanNamesForType(type, includeNonSingletons, allowEagerInit);
        }
        Map<Class<?>, String[]> cache = includeNonSingletons ? this.allBeanNamesByType : this.singletonBeanNamesByType;
        String[] resolvedBeanNames = cache.get(type);
        if (resolvedBeanNames != null) {
            return resolvedBeanNames;
        }
        resolvedBeanNames = this.doGetBeanNamesForType(type, includeNonSingletons, allowEagerInit);
        cache.put(type, resolvedBeanNames);
        return resolvedBeanNames;
    }

    private String[] doGetBeanNamesForType(Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        String[] singletonNames;
        String[] beanDefinitionNames;
        ArrayList<String> result = new ArrayList<String>();
        for (String beanName : beanDefinitionNames = this.getBeanDefinitionNames()) {
            if (this.isAlias(beanName)) continue;
            try {
                boolean matchFound;
                RootBeanDefinition mbd = this.getMergedLocalBeanDefinition(beanName);
                if (mbd.isAbstract() || !allowEagerInit && (!mbd.hasBeanClass() && mbd.isLazyInit() && !this.allowEagerClassLoading || this.requiresEagerInitForType(mbd.getFactoryBeanName()))) continue;
                boolean isFactoryBean = this.isFactoryBean(beanName, mbd);
                boolean bl = matchFound = !(!allowEagerInit && isFactoryBean && !this.containsSingleton(beanName) || !includeNonSingletons && !this.isSingleton(beanName) || !this.isTypeMatch(beanName, type));
                if (!matchFound && isFactoryBean) {
                    beanName = "&" + beanName;
                    boolean bl2 = matchFound = (includeNonSingletons || mbd.isSingleton()) && this.isTypeMatch(beanName, type);
                }
                if (!matchFound) continue;
                result.add(beanName);
            }
            catch (CannotLoadBeanClassException ex) {
                if (allowEagerInit) {
                    throw ex;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring bean class loading failure for bean '" + beanName + "'"), (Throwable)((Object)ex));
                }
                this.onSuppressedException((Exception)((Object)ex));
            }
            catch (BeanDefinitionStoreException ex) {
                if (allowEagerInit) {
                    throw ex;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring unresolvable metadata in bean definition '" + beanName + "'"), (Throwable)((Object)ex));
                }
                this.onSuppressedException((Exception)((Object)ex));
            }
        }
        for (String beanName : singletonNames = this.getSingletonNames()) {
            if (this.containsBeanDefinition(beanName)) continue;
            if (this.isFactoryBean(beanName)) {
                if ((includeNonSingletons || this.isSingleton(beanName)) && this.isTypeMatch(beanName, type)) {
                    result.add(beanName);
                    continue;
                }
                beanName = "&" + beanName;
            }
            if (!this.isTypeMatch(beanName, type)) continue;
            result.add(beanName);
        }
        return StringUtils.toStringArray(result);
    }

    private boolean requiresEagerInitForType(String factoryBeanName) {
        return factoryBeanName != null && this.isFactoryBean(factoryBeanName) && !this.containsSingleton(factoryBeanName);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        return this.getBeansOfType(type, true, true);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        String[] beanNames = this.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>(beanNames.length);
        for (String beanName : beanNames) {
            try {
                result.put(beanName, this.getBean(beanName, type));
            }
            catch (BeanCreationException ex) {
                BeanCreationException bce;
                Throwable rootCause = ex.getMostSpecificCause();
                if (rootCause instanceof BeanCurrentlyInCreationException && this.isCurrentlyInCreation((bce = (BeanCreationException)((Object)rootCause)).getBeanName())) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Ignoring match to currently created bean '" + beanName + "': " + ex.getMessage()));
                    }
                    this.onSuppressedException((Exception)((Object)ex));
                    continue;
                }
                throw ex;
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        for (String beanName : this.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = this.getBeanDefinition(beanName);
            if (beanDefinition.isAbstract() || this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            results.put(beanName, this.getBean(beanName));
        }
        for (String beanName : this.getSingletonNames()) {
            if (results.containsKey(beanName) || this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            results.put(beanName, this.getBean(beanName));
        }
        return results;
    }

    @Override
    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) {
        AbstractBeanDefinition abd;
        BeanDefinition bd;
        Annotation ann = null;
        Class<?> beanType = this.getType(beanName);
        if (beanType != null) {
            ann = AnnotationUtils.findAnnotation(beanType, annotationType);
        }
        if (ann == null && this.containsBeanDefinition(beanName) && (bd = this.getMergedBeanDefinition(beanName)) instanceof AbstractBeanDefinition && (abd = (AbstractBeanDefinition)bd).hasBeanClass()) {
            ann = AnnotationUtils.findAnnotation(abd.getBeanClass(), annotationType);
        }
        return (A)ann;
    }

    @Override
    public void registerResolvableDependency(Class<?> dependencyType, Object autowiredValue) {
        Assert.notNull(dependencyType, (String)"Type must not be null");
        if (autowiredValue != null) {
            Assert.isTrue((autowiredValue instanceof ObjectFactory || dependencyType.isInstance(autowiredValue) ? 1 : 0) != 0, (String)("Value [" + autowiredValue + "] does not implement specified type [" + dependencyType.getName() + "]"));
            this.resolvableDependencies.put(dependencyType, autowiredValue);
        }
    }

    @Override
    public boolean isAutowireCandidate(String beanName, DependencyDescriptor descriptor) throws NoSuchBeanDefinitionException {
        boolean isFactoryBean;
        boolean bl = isFactoryBean = descriptor != null && descriptor.getDependencyType() != null && FactoryBean.class.isAssignableFrom(descriptor.getDependencyType());
        if (isFactoryBean) {
            beanName = BeanFactoryUtils.transformedBeanName(beanName);
        }
        if (this.containsBeanDefinition(beanName)) {
            return this.isAutowireCandidate(beanName, this.getMergedLocalBeanDefinition(beanName), descriptor);
        }
        if (this.containsSingleton(beanName)) {
            return this.isAutowireCandidate(beanName, new RootBeanDefinition(this.getType(beanName)), descriptor);
        }
        if (this.getParentBeanFactory() instanceof ConfigurableListableBeanFactory) {
            return ((ConfigurableListableBeanFactory)this.getParentBeanFactory()).isAutowireCandidate(beanName, descriptor);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAutowireCandidate(String beanName, RootBeanDefinition mbd, DependencyDescriptor descriptor) {
        this.resolveBeanClass(mbd, beanName, new Class[0]);
        if (mbd.isFactoryMethodUnique) {
            boolean resolve;
            Object object = mbd.constructorArgumentLock;
            synchronized (object) {
                resolve = mbd.resolvedConstructorOrFactoryMethod == null;
            }
            if (resolve) {
                new ConstructorResolver(this).resolveFactoryMethodIfPossible(mbd);
            }
        }
        return this.getAutowireCandidateResolver().isAutowireCandidate(new BeanDefinitionHolder(mbd, beanName, this.getAliases(beanName)), descriptor);
    }

    @Override
    public BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        BeanDefinition bd = this.beanDefinitionMap.get(beanName);
        if (bd == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No bean named '" + beanName + "' found in " + this));
            }
            throw new NoSuchBeanDefinitionException(beanName);
        }
        return bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freezeConfiguration() {
        this.configurationFrozen = true;
        Map<String, BeanDefinition> map = this.beanDefinitionMap;
        synchronized (map) {
            this.frozenBeanDefinitionNames = StringUtils.toStringArray(this.beanDefinitionNames);
        }
    }

    @Override
    public boolean isConfigurationFrozen() {
        return this.configurationFrozen;
    }

    @Override
    protected boolean isBeanEligibleForMetadataCaching(String beanName) {
        return this.configurationFrozen || super.isBeanEligibleForMetadataCaching(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preInstantiateSingletons() throws BeansException {
        ArrayList<String> beanNames;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Pre-instantiating singletons in " + this));
        }
        Map<String, BeanDefinition> map = this.beanDefinitionMap;
        synchronized (map) {
            beanNames = new ArrayList<String>(this.beanDefinitionNames);
        }
        for (String beanName : beanNames) {
            RootBeanDefinition bd = this.getMergedLocalBeanDefinition(beanName);
            if (bd.isAbstract() || !bd.isSingleton() || bd.isLazyInit()) continue;
            if (this.isFactoryBean(beanName)) {
                boolean isEagerInit;
                final FactoryBean factory = (FactoryBean)this.getBean("&" + beanName);
                if (System.getSecurityManager() != null && factory instanceof SmartFactoryBean) {
                    isEagerInit = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            return ((SmartFactoryBean)factory).isEagerInit();
                        }
                    }, this.getAccessControlContext());
                } else {
                    boolean bl = isEagerInit = factory instanceof SmartFactoryBean && ((SmartFactoryBean)factory).isEagerInit();
                }
                if (!isEagerInit) continue;
                this.getBean(beanName);
                continue;
            }
            this.getBean(beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        Assert.hasText((String)beanName, (String)"Bean name must not be empty");
        Assert.notNull((Object)beanDefinition, (String)"BeanDefinition must not be null");
        if (beanDefinition instanceof AbstractBeanDefinition) {
            try {
                ((AbstractBeanDefinition)beanDefinition).validate();
            }
            catch (BeanDefinitionValidationException ex) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Validation of bean definition failed", (Throwable)((Object)ex));
            }
        }
        Map<String, BeanDefinition> map = this.beanDefinitionMap;
        synchronized (map) {
            BeanDefinition oldBeanDefinition = this.beanDefinitionMap.get(beanName);
            if (oldBeanDefinition != null) {
                if (!this.allowBeanDefinitionOverriding) {
                    throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Cannot register bean definition [" + beanDefinition + "] for bean '" + beanName + "': There is already [" + oldBeanDefinition + "] bound.");
                }
                if (oldBeanDefinition.getRole() < beanDefinition.getRole()) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)("Overriding user-defined bean definition for bean '" + beanName + " with a framework-generated bean definition ': replacing [" + oldBeanDefinition + "] with [" + beanDefinition + "]"));
                    }
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Overriding bean definition for bean '" + beanName + "': replacing [" + oldBeanDefinition + "] with [" + beanDefinition + "]"));
                }
            } else {
                this.beanDefinitionNames.add(beanName);
                this.frozenBeanDefinitionNames = null;
            }
            this.beanDefinitionMap.put(beanName, beanDefinition);
        }
        this.resetBeanDefinition(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        Assert.hasText((String)beanName, (String)"'beanName' must not be empty");
        Map<String, BeanDefinition> map = this.beanDefinitionMap;
        synchronized (map) {
            BeanDefinition bd = this.beanDefinitionMap.remove(beanName);
            if (bd == null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("No bean named '" + beanName + "' found in " + this));
                }
                throw new NoSuchBeanDefinitionException(beanName);
            }
            this.beanDefinitionNames.remove(beanName);
            this.frozenBeanDefinitionNames = null;
        }
        this.resetBeanDefinition(beanName);
    }

    protected void resetBeanDefinition(String beanName) {
        this.clearMergedBeanDefinition(beanName);
        this.destroySingleton(beanName);
        this.clearByTypeCache();
        for (String bdName : this.beanDefinitionNames) {
            BeanDefinition bd;
            if (beanName.equals(bdName) || !beanName.equals((bd = this.beanDefinitionMap.get(bdName)).getParentName())) continue;
            this.resetBeanDefinition(bdName);
        }
    }

    protected boolean allowAliasOverriding() {
        return this.allowBeanDefinitionOverriding;
    }

    @Override
    public void registerSingleton(String beanName, Object singletonObject) throws IllegalStateException {
        super.registerSingleton(beanName, singletonObject);
        this.clearByTypeCache();
    }

    @Override
    public void destroySingleton(String beanName) {
        super.destroySingleton(beanName);
        this.clearByTypeCache();
    }

    private void clearByTypeCache() {
        this.allBeanNamesByType.clear();
        this.singletonBeanNamesByType.clear();
    }

    @Override
    public Object resolveDependency(DependencyDescriptor descriptor, String beanName, Set<String> autowiredBeanNames, TypeConverter typeConverter) throws BeansException {
        descriptor.initParameterNameDiscovery(this.getParameterNameDiscoverer());
        if (descriptor.getDependencyType().equals(ObjectFactory.class)) {
            return new DependencyObjectFactory(descriptor, beanName);
        }
        if (descriptor.getDependencyType().equals(javaxInjectProviderClass)) {
            return new DependencyProviderFactory().createDependencyProvider(descriptor, beanName);
        }
        Object result = this.getAutowireCandidateResolver().getLazyResolutionProxyIfNecessary(descriptor, beanName);
        if (result == null) {
            result = this.doResolveDependency(descriptor, beanName, autowiredBeanNames, typeConverter);
        }
        return result;
    }

    public Object doResolveDependency(DependencyDescriptor descriptor, String beanName, Set<String> autowiredBeanNames, TypeConverter typeConverter) throws BeansException {
        Class<?> type = descriptor.getDependencyType();
        Object value = this.getAutowireCandidateResolver().getSuggestedValue(descriptor);
        if (value != null) {
            if (value instanceof String) {
                String strVal = this.resolveEmbeddedValue((String)value);
                BeanDefinition bd = beanName != null && this.containsBean(beanName) ? this.getMergedBeanDefinition(beanName) : null;
                value = this.evaluateBeanDefinitionString(strVal, bd);
            }
            TypeConverter converter = typeConverter != null ? typeConverter : this.getTypeConverter();
            return descriptor.getField() != null ? converter.convertIfNecessary(value, type, descriptor.getField()) : converter.convertIfNecessary(value, type, descriptor.getMethodParameter());
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, componentType, descriptor);
            if (matchingBeans.isEmpty()) {
                if (descriptor.isRequired()) {
                    this.raiseNoSuchBeanDefinitionException(componentType, "array of " + componentType.getName(), descriptor);
                }
                return null;
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll(matchingBeans.keySet());
            }
            TypeConverter converter = typeConverter != null ? typeConverter : this.getTypeConverter();
            Object result = converter.convertIfNecessary(matchingBeans.values(), type);
            if (this.dependencyComparator != null && result instanceof Object[]) {
                Arrays.sort((Object[])result, this.dependencyComparator);
            }
            return result;
        }
        if (Collection.class.isAssignableFrom(type) && type.isInterface()) {
            Class<?> elementType = descriptor.getCollectionType();
            if (elementType == null) {
                if (descriptor.isRequired()) {
                    throw new FatalBeanException("No element type declared for collection [" + type.getName() + "]");
                }
                return null;
            }
            Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, elementType, descriptor);
            if (matchingBeans.isEmpty()) {
                if (descriptor.isRequired()) {
                    this.raiseNoSuchBeanDefinitionException(elementType, "collection of " + elementType.getName(), descriptor);
                }
                return null;
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll(matchingBeans.keySet());
            }
            TypeConverter converter = typeConverter != null ? typeConverter : this.getTypeConverter();
            Object result = converter.convertIfNecessary(matchingBeans.values(), type);
            if (this.dependencyComparator != null && result instanceof List) {
                Collections.sort((List)result, this.dependencyComparator);
            }
            return result;
        }
        if (Map.class.isAssignableFrom(type) && type.isInterface()) {
            Class<?> keyType = descriptor.getMapKeyType();
            if (keyType == null || !String.class.isAssignableFrom(keyType)) {
                if (descriptor.isRequired()) {
                    throw new FatalBeanException("Key type [" + keyType + "] of map [" + type.getName() + "] must be assignable to [java.lang.String]");
                }
                return null;
            }
            Class<?> valueType = descriptor.getMapValueType();
            if (valueType == null) {
                if (descriptor.isRequired()) {
                    throw new FatalBeanException("No value type declared for map [" + type.getName() + "]");
                }
                return null;
            }
            Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, valueType, descriptor);
            if (matchingBeans.isEmpty()) {
                if (descriptor.isRequired()) {
                    this.raiseNoSuchBeanDefinitionException(valueType, "map with value type " + valueType.getName(), descriptor);
                }
                return null;
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll(matchingBeans.keySet());
            }
            return matchingBeans;
        }
        Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, type, descriptor);
        if (matchingBeans.isEmpty()) {
            if (descriptor.isRequired()) {
                this.raiseNoSuchBeanDefinitionException(type, "", descriptor);
            }
            return null;
        }
        if (matchingBeans.size() > 1) {
            String primaryBeanName = this.determinePrimaryCandidate(matchingBeans, descriptor);
            if (primaryBeanName == null) {
                throw new NoUniqueBeanDefinitionException(type, matchingBeans.keySet());
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.add(primaryBeanName);
            }
            return matchingBeans.get(primaryBeanName);
        }
        Map.Entry<String, Object> entry = matchingBeans.entrySet().iterator().next();
        if (autowiredBeanNames != null) {
            autowiredBeanNames.add(entry.getKey());
        }
        return entry.getValue();
    }

    protected Map<String, Object> findAutowireCandidates(String beanName, Class<?> requiredType, DependencyDescriptor descriptor) {
        String[] candidateNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this, requiredType, true, descriptor.isEager());
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(candidateNames.length);
        for (Class<?> autowiringType : this.resolvableDependencies.keySet()) {
            if (!autowiringType.isAssignableFrom(requiredType)) continue;
            Object autowiringValue = this.resolvableDependencies.get(autowiringType);
            if (!requiredType.isInstance(autowiringValue = AutowireUtils.resolveAutowiringValue(autowiringValue, requiredType))) continue;
            result.put(ObjectUtils.identityToString((Object)autowiringValue), autowiringValue);
            break;
        }
        for (String candidateName : candidateNames) {
            if (candidateName.equals(beanName) || !this.isAutowireCandidate(candidateName, descriptor)) continue;
            result.put(candidateName, this.getBean(candidateName));
        }
        return result;
    }

    protected String determinePrimaryCandidate(Map<String, Object> candidateBeans, DependencyDescriptor descriptor) {
        String primaryBeanName = null;
        String fallbackBeanName = null;
        for (Map.Entry<String, Object> entry : candidateBeans.entrySet()) {
            Object beanInstance;
            String candidateBeanName = entry.getKey();
            if (this.isPrimary(candidateBeanName, beanInstance = entry.getValue())) {
                if (primaryBeanName != null) {
                    boolean primaryLocal;
                    boolean candidateLocal = this.containsBeanDefinition(candidateBeanName);
                    if (candidateLocal == (primaryLocal = this.containsBeanDefinition(primaryBeanName))) {
                        throw new NoUniqueBeanDefinitionException(descriptor.getDependencyType(), candidateBeans.size(), "more than one 'primary' bean found among candidates: " + candidateBeans.keySet());
                    }
                    if (candidateLocal && !primaryLocal) {
                        primaryBeanName = candidateBeanName;
                    }
                } else {
                    primaryBeanName = candidateBeanName;
                }
            }
            if (primaryBeanName != null || !this.resolvableDependencies.values().contains(beanInstance) && !this.matchesBeanName(candidateBeanName, descriptor.getDependencyName())) continue;
            fallbackBeanName = candidateBeanName;
        }
        return primaryBeanName != null ? primaryBeanName : fallbackBeanName;
    }

    protected boolean isPrimary(String beanName, Object beanInstance) {
        if (this.containsBeanDefinition(beanName)) {
            return this.getMergedLocalBeanDefinition(beanName).isPrimary();
        }
        BeanFactory parentFactory = this.getParentBeanFactory();
        return parentFactory instanceof DefaultListableBeanFactory && ((DefaultListableBeanFactory)parentFactory).isPrimary(beanName, beanInstance);
    }

    protected boolean matchesBeanName(String beanName, String candidateName) {
        return candidateName != null && (candidateName.equals(beanName) || ObjectUtils.containsElement((Object[])this.getAliases(beanName), (Object)candidateName));
    }

    private void raiseNoSuchBeanDefinitionException(Class<?> type, String dependencyDescription, DependencyDescriptor descriptor) throws NoSuchBeanDefinitionException {
        throw new NoSuchBeanDefinitionException(type, dependencyDescription, "expected at least 1 bean which qualifies as autowire candidate for this dependency. Dependency annotations: " + ObjectUtils.nullSafeToString((Object[])descriptor.getAnnotations()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ObjectUtils.identityToString((Object)this));
        sb.append(": defining beans [");
        sb.append(StringUtils.arrayToCommaDelimitedString((Object[])this.getBeanDefinitionNames()));
        sb.append("]; ");
        BeanFactory parent = this.getParentBeanFactory();
        if (parent == null) {
            sb.append("root of factory hierarchy");
        } else {
            sb.append("parent: ").append(ObjectUtils.identityToString((Object)parent));
        }
        return sb.toString();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        throw new NotSerializableException("DefaultListableBeanFactory itself is not deserializable - just a SerializedBeanFactoryReference is");
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.serializationId != null) {
            return new SerializedBeanFactoryReference(this.serializationId);
        }
        throw new NotSerializableException("DefaultListableBeanFactory has no serialization id");
    }

    static {
        ClassLoader cl = DefaultListableBeanFactory.class.getClassLoader();
        try {
            javaxInjectProviderClass = cl.loadClass("javax.inject.Provider");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        serializableFactories = new ConcurrentHashMap<String, Reference<DefaultListableBeanFactory>>(8);
    }

    private class DependencyProviderFactory {
        private DependencyProviderFactory() {
        }

        public Object createDependencyProvider(DependencyDescriptor descriptor, String beanName) {
            return new DependencyProvider(descriptor, beanName);
        }
    }

    private class DependencyProvider
    extends DependencyObjectFactory
    implements Provider<Object> {
        public DependencyProvider(DependencyDescriptor descriptor, String beanName) {
            super(descriptor, beanName);
        }

        public Object get() throws BeansException {
            return this.getObject();
        }
    }

    private class DependencyObjectFactory
    implements ObjectFactory<Object>,
    Serializable {
        private final DependencyDescriptor descriptor;
        private final String beanName;

        public DependencyObjectFactory(DependencyDescriptor descriptor, String beanName) {
            this.descriptor = new DependencyDescriptor(descriptor);
            this.descriptor.increaseNestingLevel();
            this.beanName = beanName;
        }

        @Override
        public Object getObject() throws BeansException {
            return DefaultListableBeanFactory.this.doResolveDependency(this.descriptor, this.beanName, null, null);
        }
    }

    private static class SerializedBeanFactoryReference
    implements Serializable {
        private final String id;

        public SerializedBeanFactoryReference(String id) {
            this.id = id;
        }

        private Object readResolve() {
            Reference ref = (Reference)serializableFactories.get(this.id);
            if (ref == null) {
                throw new IllegalStateException("Cannot deserialize BeanFactory with id " + this.id + ": no factory registered for this id");
            }
            Object result = ref.get();
            if (result == null) {
                throw new IllegalStateException("Cannot deserialize BeanFactory with id " + this.id + ": factory has been garbage-collected");
            }
            return result;
        }
    }
}

