/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class BeanMetadataAttribute
implements BeanMetadataElement {
    private final String name;
    private final Object value;
    private Object source;

    public BeanMetadataAttribute(String name, @Nullable Object value) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setSource(@Nullable Object source) {
        this.source = source;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeanMetadataAttribute)) {
            return false;
        }
        BeanMetadataAttribute otherMa = (BeanMetadataAttribute)other;
        return this.name.equals(otherMa.name) && ObjectUtils.nullSafeEquals((Object)this.value, (Object)otherMa.value) && ObjectUtils.nullSafeEquals((Object)this.source, (Object)otherMa.source);
    }

    public int hashCode() {
        return this.name.hashCode() * 29 + ObjectUtils.nullSafeHashCode((Object)this.value);
    }

    public String toString() {
        return "metadata attribute '" + this.name + "'";
    }
}

