/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class LookupOverride
extends MethodOverride {
    private final String beanName;
    private Method method;

    public LookupOverride(String methodName, @Nullable String beanName) {
        super(methodName);
        this.beanName = beanName;
    }

    public LookupOverride(Method method, @Nullable String beanName) {
        super(method.getName());
        this.method = method;
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public boolean matches(Method method) {
        if (this.method != null) {
            return method.equals(this.method);
        }
        return method.getName().equals(this.getMethodName()) && (!this.isOverloaded() || Modifier.isAbstract(method.getModifiers()) || method.getParameterCount() == 0);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof LookupOverride) || !super.equals(other)) {
            return false;
        }
        LookupOverride that = (LookupOverride)other;
        return ObjectUtils.nullSafeEquals((Object)this.method, (Object)that.method) && ObjectUtils.nullSafeEquals((Object)this.beanName, (Object)that.beanName);
    }

    @Override
    public int hashCode() {
        return 29 * super.hashCode() + ObjectUtils.nullSafeHashCode((Object)this.beanName);
    }

    public String toString() {
        return "LookupOverride for method '" + this.getMethodName() + "'";
    }
}

