/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.Converter;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class ConversionExecutor
implements Serializable {
    private final Class sourceClass;
    private final Class targetClass;
    private final Converter converter;

    public ConversionExecutor(Class sourceClass, Class targetClass, Converter converter) {
        Assert.notNull((Object)sourceClass, (String)"The source class is required");
        Assert.notNull((Object)targetClass, (String)"The target class is required");
        Assert.notNull((Object)converter, (String)"The converter is required");
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
        this.converter = converter;
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public Object execute(Object source) throws ConversionException {
        return this.execute(source, Collections.EMPTY_MAP);
    }

    public Object execute(Object source, Map context) throws ConversionException {
        if (source != null) {
            Assert.isInstanceOf((Class)this.sourceClass, (Object)source, (String)"Not of source type: ");
        }
        return this.converter.convert(source, this.targetClass, context);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConversionExecutor)) {
            return false;
        }
        ConversionExecutor other = (ConversionExecutor)o;
        return this.sourceClass.equals(other.sourceClass) && this.targetClass.equals(other.targetClass);
    }

    public int hashCode() {
        return this.sourceClass.hashCode() + this.targetClass.hashCode();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("sourceClass", (Object)this.sourceClass).append("targetClass", (Object)this.targetClass).toString();
    }
}

