/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.format.support;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.springframework.binding.format.Formatter;
import org.springframework.binding.format.Style;
import org.springframework.binding.format.support.AbstractFormatterFactory;
import org.springframework.binding.format.support.DateFormatter;
import org.springframework.binding.format.support.NumberFormatter;

public class SimpleFormatterFactory
extends AbstractFormatterFactory {
    public Formatter getDateFormatter(Style style) {
        return new DateFormatter(SimpleDateFormat.getDateInstance(style.shortValue(), this.getLocale()));
    }

    public Formatter getDateTimeFormatter(Style dateStyle, Style timeStyle) {
        return new DateFormatter(SimpleDateFormat.getDateTimeInstance(dateStyle.shortValue(), timeStyle.shortValue(), this.getLocale()));
    }

    public Formatter getTimeFormatter(Style style) {
        return new DateFormatter(SimpleDateFormat.getTimeInstance(style.shortValue(), this.getLocale()));
    }

    public Formatter getNumberFormatter(Class numberClass) {
        return new NumberFormatter(NumberFormat.getNumberInstance(this.getLocale()));
    }

    public Formatter getCurrencyFormatter() {
        return new NumberFormatter(NumberFormat.getCurrencyInstance(this.getLocale()));
    }

    public Formatter getDateFormatter(String encodedFormat) {
        return new DateFormatter(new SimpleDateFormat(encodedFormat));
    }

    public Formatter getPercentFormatter() {
        return new NumberFormatter(NumberFormat.getPercentInstance(this.getLocale()));
    }
}

