/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.mapping;

import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.support.DefaultConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.PropertyExpression;
import org.springframework.binding.mapping.Mapping;
import org.springframework.util.Assert;

public class MappingBuilder {
    private Expression sourceExpression;
    private PropertyExpression targetExpression;
    private Class sourceType;
    private Class targetType;
    private ExpressionParser expressionParser;
    private ConversionService conversionService = new DefaultConversionService();

    public MappingBuilder(ExpressionParser expressionParser) {
        Assert.notNull((Object)expressionParser, (String)"The expression parser is required");
        this.expressionParser = expressionParser;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public MappingBuilder source(String expressionString) {
        this.sourceExpression = this.expressionParser.parseExpression(expressionString);
        return this;
    }

    public MappingBuilder target(String expressionString) {
        this.targetExpression = (PropertyExpression)this.expressionParser.parseExpression(expressionString);
        return this;
    }

    public MappingBuilder from(Class sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public MappingBuilder to(Class targetType) {
        this.targetType = targetType;
        return this;
    }

    public Mapping value() {
        Assert.notNull((Object)this.sourceExpression, (String)"The source expression must be set at a minimum");
        if (this.targetExpression == null) {
            this.targetExpression = (PropertyExpression)this.sourceExpression;
        }
        ConversionExecutor typeConverter = null;
        if (this.sourceType != null) {
            Assert.notNull((Object)this.targetType, (String)"The target type is required when the source type is specified");
            typeConverter = this.conversionService.getConversionExecutor(this.sourceType, this.targetType);
        }
        Mapping result = new Mapping(this.sourceExpression, this.targetExpression, typeConverter);
        this.sourceExpression = null;
        this.targetExpression = null;
        this.sourceType = null;
        this.targetType = null;
        return result;
    }
}

