/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.support;

import java.util.Collections;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.springframework.binding.expression.EvaluationAttempt;
import org.springframework.binding.expression.EvaluationContext;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.SetValueAttempt;
import org.springframework.binding.expression.SettableExpression;
import org.springframework.util.Assert;

class OgnlExpression
implements SettableExpression {
    private Object expression;

    public OgnlExpression(Object expression) {
        this.expression = expression;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OgnlExpression)) {
            return false;
        }
        OgnlExpression other = (OgnlExpression)o;
        return this.expression.equals(other.expression);
    }

    public Object evaluate(Object target, EvaluationContext context) throws EvaluationException {
        Assert.notNull((Object)target, (String)"The target object to evaluate is required");
        Map contextAttributes = context != null ? context.getAttributes() : Collections.EMPTY_MAP;
        try {
            return Ognl.getValue((Object)this.expression, (Map)contextAttributes, (Object)target);
        }
        catch (OgnlException e) {
            throw new EvaluationException(new EvaluationAttempt(this, target, contextAttributes), e);
        }
    }

    public void evaluateToSet(Object target, Object value, EvaluationContext context) {
        Assert.notNull((Object)target, (String)"The target object to evaluate is required");
        Map contextAttributes = context != null ? context.getAttributes() : Collections.EMPTY_MAP;
        try {
            Ognl.setValue((Object)this.expression, (Map)contextAttributes, (Object)target, (Object)value);
        }
        catch (OgnlException e) {
            throw new EvaluationException(new SetValueAttempt(this, target, value, contextAttributes), e);
        }
    }

    public String toString() {
        return this.expression.toString();
    }
}

